# Makefile to make release of multips
.KEEP_STATE:
FILES = multips.base multi.ps multips.1
BIN = /usr/local/bin
MANDIR = /usr/nith/man
SECT = 1
# Note that any / characters should be protected by a \ character 
# So that the sed command will work.
PSLIB = \/usr\/local\/lib\/ps

all : $(FILES) 

release : $(FILES)
	rm -fr $@ $@.tar $@.tar.Z $@.tar.Z.u
	mkdir ./release
	cp $(FILES) $@
	tar cvf - $@ > $@.tar
	compress $@.tar
	uuencode $@.tar.Z $@.tar.Z > $@.tar.Z.u

install : $(FILES)
	[ -d $(PSLIB) ]
	sed 's/PSLIB=/PSLIB=\"$(PSLIB)\"/' multips.base > multips
	[ -d $(BIN) ]
	install multips $(BIN)
	install -m 744 multi.ps $(PSLIB)
	[ -d $(MANDIR) ]
	[ -d $(MANDIR)/cat$(SECT) ]
	[ -d $(MANDIR)/man$(SECT) ]
	nroff -man multips.1 > $(MANDIR)/cat$(SECT)/multips.$(SECT)
	install multips.1 $(MANDIR)/man$(SECT)
	
clean :
	rm -rf release* multips
