/*========================================================================*
 * TITLE:	telnetdp -- a telnetd pre processor
 * MODULE:	telnetdp.c
 * BY:		Ross C Linder	ross@wanda.iaccess.za
 * (C):		GPL
 * ADEPTATION:	/etc/issue parser from agetty <wietse@wzv.win.tue.nl>
 *
 * This will display /etc/issue for telnet sessions, usefull for
 * BBS's & stuff.
 *
 * To install, place executable in the net "daemons" directory, the
 * same place you find telnetd in, and then change /etc/inetd.conf
 * to have telnet sessions as so.
 *
 * telnet  stream  tcp   nowait  root  /usr/net/daemons/telnetdp    /usr/net/daemons/telnetd
 *                                     ^^^^^^^^^^^^^^^^
 * Where this is your daemons directory.
 *
 * NOTE: !! the path to the real telnetd daemon must be fully specified !!
 *========================================================================*/

#include <stdio.h>
#include <time.h>
#include <sys/utsname.h>
#include <sys/types.h>


/*========================================================================*
 * MAIN -- Basically display /etc/issue if its there
 *========================================================================*/

main (int argc, char *argv[])
{
FILE		*fp;
int		c;
struct utsname	un;
struct tm	*tm;
time_t		now;
char		*wd[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
char		*mn[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
				       "Aug", "Sep", "Oct", "Nov", "Dec"};

    if ((fp = fopen ("/etc/issue", "r")) != NULL) {
	uname (&un);;

	while ((c = getc (fp)) != -1) {
	    if (c == '\\') {
		switch (c = getc (fp)) {
		    case 's' :
			fprintf (stderr, "%s", un.sysname);
			break;

		    case 'n' :
			fprintf (stderr, "%s", un.nodename);
			break;

		    case 'r' :
			fprintf (stderr, "%s", un.release);
			break;

		    case 'v' :
			fprintf (stderr, "%s", un.version);
			break;

		    case 'm' :
			fprintf (stderr, "%s", un.machine);
			break;

		    case 'd' :
			time (&now);
			tm = localtime (&now);
			fprintf (stderr, "%s %s %d  %d", wd[tm->tm_wday],
				mn[tm->tm_mon], tm->tm_mday, tm->tm_year < 70
 				? tm->tm_year + 2000 : tm->tm_year + 1900);
			break;

		    case 't' :
			time (&now);
			tm = localtime (&now);
			fprintf (stderr, "%02d:%02d:%02d", tm->tm_hour,
				tm->tm_min, tm->tm_sec);
			break;

		    case 'l' :		/* This is telnet ! */
		    case 'b' :
			fprintf (stderr, "net");
			break;

		    default :
			fputc (c, stderr);
		    }
		}
	    else
		fputc (c, stderr);
	    }

	fclose (fp);
	}

    execv (argv[0], argv);
}
