/*
 * mknbi.h  -  mknbi constants and type definitions
 *
 * Copyright (C) 1995 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MKNBI_H_
#define _MKNBI_H_


/*
 * The RAM looks like this after the boot image has been loaded by the
 * Boot-ROM:
 *
 *  0x10000-0x8FFFF	512kB	kernel and part of kernel setup
 *  0x90000-0x901FF	0.5kB	linux floppy boot sector
 *  0x90200-0x90FFF	3.5kB	first sectors of kernel setup
 *  0x91000-0x91FFF	  4kB	primary boot loader
 *  0x92000-0x921FF	0.5kB	load header
 *  0x92200-0x929FF	  2kB	default command line
 */
#include <linux/config.h>

#ifndef DEF_SYSSEG		/* usually defined in linux/config.h */
#  define DEF_SYSSEG	0x1000
#endif
#define SYSLSIZE	524288	/* maximum load size of kernel */
#define SYSMSIZE	524288	/* maximum memory size of kernel */

#ifndef DEF_INITSEG		/* usually defined in linux/config.h */
#  define DEF_INITSEG	0x9000
#endif
#define INITLSIZE	512	/* maximum load size of floppy boot sector */
#define INITMSIZE	512	/* maximum memory size of floppy boot sector */

#ifndef DEF_SETUPSEG		/* usually defined in linux/config.h */
#  define DEF_SETUPSEG	0x9020
#endif
#define SETUPLSIZE	2048	/* maximum load size of kernel setup */
#define SETUPMSIZE	40448	/* maximum memory size of kernel setup */

#ifndef DEF_BOOTLSEG		/* this is NOT defined in linux/config.h */
#  define DEF_BOOTLSEG	0x9100
#endif
#define BOOTLLSIZE	4096	/* maximum load size of primary boot loader */
#define BOOTLMSIZE	4096	/* maximum memory size of primary boot loader */

#ifndef DEF_CMDLSEG		/* this is NOT defined in linux/config.h */
#  define DEF_CMDLSEG	0x9220
#endif
#define CMDLLSIZE	512	/* maximum load size of default command line */
#define CMDLMSIZE	2048	/* maximum memory size of def. command line */

#ifndef DEF_HEADERSEG		/* this is NOT defined in linux/config.h */
#  define DEF_HEADERSEG	0x9200
#endif
#define HEADERLSIZE	512	/* maximum load size of boot image header */
#define HEADERMSIZE	512	/* maximum memory size of boot image header */



/*
 * Default values for command line etc.
 */
#define SECTSIZE	512			/* Size of one sector */

#define BOOT_SIGNATURE	0xaa55			/* boot signature */
#define BOOT_SIG_OFFSET	510			/* boot signature offset */

#define DFLT_CMDL	"auto rw root=/dev/nfs"	/* Default command line */
#define DFLT_IMAGE	"/vmlinuz"		/* Name of default krnl image */
#define DFLT_DIR	"kernel"		/* Name of default NFS dir */
#define DFLT_ADDRS	"kernel"		/* Default address resolution */
#define NFS_ROOT	" nfsroot="		/* nfsroot option for kernel */
#define NFS_ADDRS	" nfsaddrs="		/* nfsaddrs option for kernel */



/*
 * The boot image has to contain this Intel-type segment:offset address
 */
struct i_addr {
  unsigned short offset;
  unsigned short segment;
};



/*
 * The boot image has the following header in it's first sector
 */
struct load_header {
  unsigned long  magic;			/* magic number */
  unsigned char  hlength;		/* length of header - fixed number */
  unsigned char  hflags1;		/* header flags */
  unsigned char  hflags2;
  unsigned char  hflags3;
  struct i_addr  locn;			/* location of this header after boot */
  struct i_addr  execute;		/* execution address */
  unsigned char  dummy[494];		/* bring us up to a full sector */
  unsigned short bootsig;		/* boot signature */
};

#define HEADER_MAGIC	0x1B031336	/* Magic number for load header */



/*
 * In the header sector are the load records located, which actually tell
 * which part of the following image has to go where in memory
 */
struct load_record {
  unsigned char  rlength;		/* length of record - fixed number */
  unsigned char  rtag1;			/* record tags */
  unsigned char  rtag2;
  unsigned char  rflags;		/* record flags */
  unsigned long  address;		/* absolute address for part in mem */
  unsigned long  ilength;		/* length of part in boot image */
  unsigned long  mlength;		/* amount of memory needed for part */
};

#define FLAG_B0		1
#define FLAG_B1		2
#define FLAG_EOF	4



/*
 * Number of each load record. Don't change the loading order of the
 * modules by changing these numbers, because the whole kernel gets
 * loaded in one big chunk, while the records really split the kernel
 * image in memory. These values have to be identical with those in
 * the include file of the boot loader assembler module.
 */
#define BOOTLNUM	0		/* primary boot loader */
#define CMDLNUM		1		/* command line */
#define INITNUM		2		/* floppy boot sector */
#define SETUPNUM	3		/* kernel setup */
#define KERNELNUM	4		/* kernel image */

#define NUM_RECORDS	5

extern struct load_record *rec_list[NUM_RECORDS];	/* ptrs to records */


#define VENDOR_ID	"GK-mknbi"	/* Vendor ID */
#define VENDOR_OFFSET	16		/* Offset for vendor tags */



/*
 * Data area which contains the boot loader module
 */
extern char first_data[];
extern int first_data_size;


#endif
