#ifndef BOOTINC_H
#define BOOTINC_H

#include "config.h"

#ifndef NULL
#define NULL	(0)
#endif

#ifdef DEBUG
# define BUG(__s) n_printf("%s[%d]: %s\n",__FILE__,__LINE__,__s);
# define VPRINT(s) n_putscrlf(s)
#else
# define BUG(__s)
# define VPRINT(s)
#endif

#ifndef MK_FP
#define MK_FP(seg,ofs)  ((void far *) \
			   (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#endif

/* because the reading of the buffer is syncronous with the
   code, there is no need to have a large buffer
*/

#define RAW_LENGTH		(7000)
#define RAW_END_LENGTH 		(RAW_LENGTH - 2048)
#define RAW_LIMIT_LENGTH	(RAW_END_LENGTH - 4096)

/*
*   Declarations of global variables for TCP/IP libraries
*
****************************************************************************
*                                                                          *
*                                                                          *
*      NCSA Telnet                                                         *
*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
*    Copyright (c) 1987, Board of Trustees of the University of Illinois   *
*                                                                          *
****************************************************************************
*
*/

/*
*  Start with declarations that tell the difference between PC and other
*  computers
*/

extern unsigned char bseed[],
                ltseed[],
                raw[];

extern unsigned char
                nnmyaddr[DADDLEN],	       /* my ethernet hardware
					        * address */
                nnserveraddr[DADDLEN],	       /* server's ethernet hardware
					        * address */
                broadaddr[DADDLEN],	       /* the broadcast address */
                nnipnum[4],		       /* my ip number */
                nnipserver[4],		       /* server's ip number */
                broadip[4];

extern int
                nnipident;		       /* ident field of outgoing ip
					        * packets */

extern int      debug;

extern struct pseudotcp tcps;		       /* for checksums */
extern struct pseudotcp utcps;		       /* for checksums */

extern DLAYER   blankd;
extern IPKT     blankip;

extern UDPKT    udp_rxdata;
extern UDPKT    udpout;

extern int start_of_data;
extern int end_of_data;
extern int end_of_bss;

/*
*   defines for types for functions, global to everyone
*/
char           *nbgets();
uint8          *getdlayer(), *netdlayer();

/*
*   defines of constants and macros that everyone needs to know
*/


/* net.c */
#include "protocol.h"

extern int      netparms(uint irq, uint address, uint ioaddr, uint extra);
extern void     netconfig(char *s);
extern int      initbuffer(void);
extern int      ethrecv(IPKT * p);
extern int      dlayersend(struct ether * ptr, unsigned int size);
extern int      dlayerinit(void);
extern void     dlayershut(void);
extern void     pcgetaddr(char *s, int x, int y);

/* udp.c */
extern void     udpdump(UDPKT * p);
extern int      udprecv(UDPKT * p, uint uport);
extern int      netusend(unsigned char *machine, unsigned char *eaddr, uint port, uint retport, unsigned char *buffer, int n);

/* ip.c */
extern void     ipdump(IPKT * p);
extern int      iprecv(IPKT * p);

/*  arp.c */
extern int arpinterpret(ARPKT *p);

/* bootp.c */

extern int      bootp(char *name, int len, void **bpbuf);

/*   tftp.c */

extern int      tftp_get(char *name);


/* general */
extern void     netposterr(int num);
extern int      init(char *ifname);
extern void     udp_reinit(void);

/* decoder */
extern int 	decode_header(void *ptr);
extern int	place_data(char *data, int len);
extern void	warp_speed_Mr_spock(void *bpbuf);

#include "utils.h"

#endif
