#ifndef _LINUX_DMSDOS_FS_H
#define _LINUX_DMSDOS_FS_H

/*
 * The MS-DOS filesystem constants/structures
 */
#include <linux/fs.h>
#include <linux/stat.h>
#include <linux/fd.h>

#ifdef __KERNEL__

#define MAXDBLFILES 10
#define MDFATCACHESIZE 40
#define DFATCACHESIZE 20
#define MAXFRAGMENT 20

extern int dmsdos_lookup(struct inode *dir,const char *name,int len,
	struct inode **result);
extern int dmsdos_create(struct inode *dir,const char *name,int len,int mode,
	struct inode **result);
extern int dmsdos_mkdir(struct inode *dir,const char *name,int len,int mode);
extern int dmsdos_rmdir(struct inode *dir,const char *name,int len);
extern int dmsdos_unlink(struct inode *dir,const char *name,int len);
extern int dmsdos_rename(struct inode *old_dir,const char *old_name,int old_len,
	struct inode *new_dir,const char *new_name,int new_len);
extern void dmsdos_put_inode(struct inode *inode);
extern void dmsdos_put_super(struct super_block *sb);
extern struct super_block *dmsdos_read_super(struct super_block *s,
					    void *data,int);
extern void dmsdos_statfs(struct super_block *sb,struct statfs *buf);
extern int dmsdos_bmap(struct inode *inode,int block);
extern void dmsdos_read_inode(struct inode *inode);
extern void dmsdos_write_inode(struct inode *inode);
extern int dmsdos_notify_change(struct inode *,struct iattr *);
extern struct inode_operations dmsdos_dir_inode_operations;
extern int dmsdos_readdir (struct inode *inode, struct file *filp,
	struct dirent *dirent, int count);
extern struct inode_operations dmsdos_file_inode_operations;
extern struct inode_operations dmsdos_file_inode_operations_1024;
extern int dmsdos_file_read(struct inode *, struct file *, char *, int);
extern int dmsdos_file_write(struct inode *, struct file *, char *, int);
extern struct inode_operations dmsdos_file_inode_operations_no_bmap;
extern void dmsdos_truncate(struct inode *inode);
extern int dmsdos_mmap(struct inode *, struct file *, struct vm_area_struct *);

typedef struct {
  int s_dcluster;/*[45-46]*/
  int s_mdfatstart;/*[36-37]+1*/
  int s_fatstart;/*[39-40]+[14-15]*/ 
  int s_rootdir;/*[41-42]+[39-40]*/
  int s_rootdiranzentry;
  int s_sectperclust;
  int s_first[MAXFRAGMENT];
  int s_anzahl[MAXFRAGMENT];
  int s_16bitfat;
} Dblsb;

typedef struct {
  struct buffer_head * a_buffer;
  unsigned int a_area;
  unsigned int a_used;
  unsigned int a_cvfnr;
} Acache;

struct buffer_head* read_dbl_sector(struct super_block*,
                                    int dblsector,int cvfnr);
void bh_free(struct super_block*, struct buffer_head*);
int dbl_mdfat_value(struct super_block*,int clusternr,int cvfnr);
int dbl_fat_nextcluster(struct super_block*,int clusternr,int cvfnr);
int dbltest(struct inode* inode);
int dostest(struct inode* inode);
void dbl_init(struct super_block* sb, void* datai, int silent);
int dmsdos_readdirx( 
	struct inode *inode,
	struct file *filp,
	struct dirent *dirent,	/* dirent in user space */
	int count);
int dmsdos_file_readx(
	struct inode *inode,
	struct file *filp,
	char *buf,
	int count);
void dmsdos_read_inodex(struct inode *inode);
int dmsdos_lookupx(struct inode *dir,const char *name,int len,
    struct inode **result);
int dmsdos_read_cluster(struct super_block*,
                        unsigned char*clusterd, int clusternr,int cvfnr);
void exit_dbl(struct super_block*sb);

#endif /* __KERNEL__ */

#endif
