/*
linux/fs/dmsdos/dmsdos_dec.c

DMSDOS filesystem: decompression routines

Curently DS-0-0 and DS-0-1 methods unsupported - sorry.
If you have any doc about those and other compression methods used in CVFs,
please send them to me so I can try to include them into the DMSDOS filesystem.

Email address see docs or file dmsdos_spc.c.
                                                        
*/

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/stat.h>
#include <linux/mm.h>
#include <linux/locks.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/msdos_fs.h>
#include <linux/dmsdos_fs.h>

#include <asm/system.h>
#include <asm/segment.h>
#include <asm/bitops.h>

extern Dblsb dblsb[];

/* cluster caching...has to be reprogrammed (?)
   disabled due to multiple read problems 
   (besides, I did not notice any speedup)
unsigned char* ldc=NULL;
int ldc_cvfnr;
int ldc_cnr;
*/

/* known compression methods */
#define DS_0_0 0x00005344
#define DS_0_1 0x01005344
#define DS_0_2 0x02005344
#define JM_0_0 0x00004D4A

int getbit(unsigned char*clusterk,int*mask,int*count)
{ int ret;

  ret=(*mask)&clusterk[*count];
  (*mask)<<=1;
  if(*mask==256)
  { *mask=1;
    (*count)++;
  }  
  return ret;
}

int getbits(unsigned char*clusterk,int*mask,int*count,int bits)
{ int orwert=1;
  int ret=0;
  int i;
  
  for(i=0;i<bits;++i)
  { if(getbit(clusterk,mask,count))ret|=orwert;
    orwert<<=1;
  }
  return ret;
}

int getDX(unsigned char*clusterk,int*mask,int*count)
{ if(!getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,6);
  if(!getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,8)+64;
  return getbits(clusterk,mask,count,12)+320;
}

int getCX(unsigned char*clusterk,int*mask,int*count)
{ if(getbit(clusterk,mask,count)) return 3;
  if(getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,1)+4;
  if(getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,2)+6;
  if(getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,3)+10;
  if(getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,4)+18;
  if(getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,5)+34;
  if(getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,6)+66;
  if(getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,7)+130;
  if(getbit(clusterk,mask,count)) return getbits(clusterk,mask,count,8)+258;
  return -1;
}

int decrb(unsigned char*clusterk,int*mask,int*count,
          unsigned char*clusterd,int*pos,int*sek,int dx,int k)
{ int i,cx;

  if(dx==0)return -2;
  if(dx==0x113f)
  { (*sek)--;
    if(*sek==0)return -1;
    if(*pos%SECTOR_SIZE) return -2;
    return 0;
  }
  cx=getCX(clusterk,mask,count)+k;
  if(cx<=0)return -2;
  if(dx>*pos) return -2;
  for(i=0;i<cx;i++)clusterd[(*pos)+i]=clusterd[(*pos)+i-dx];
  (*pos)+=cx;
  return 0;
}

/* decompress a compressed cluster clusterk to clusterd */
int decompress(unsigned char*clusterd, unsigned char*clusterk,int mdfatval)
{
	int sekcount;
	int r,count,mask,pos,dx;

	/*printk("DMSDOS: decompress: mdfatval=%d\n",mdfatval);*/

	sekcount=((mdfatval&0x3c000000)>>26)+1;
	count=0;
	mask=1;
	pos=0;

  switch(getbits(clusterk,&mask,&count,32))
  {
    case DS_0_0:
	printk("DMSDOS: Sorry, DS-0-0 compression method unsupported.\n");
	return -1;
    
    case DS_0_1:
	printk("DMSDOS: Sorry, DS-0-1 compression method unsupported.\n");
	return -1;
    
    case DS_0_2:
        do
        { r=0;
          if(!getbit(clusterk,&mask,&count))
          { if(getbit(clusterk,&mask,&count))
            { clusterd[pos++]=getbits(clusterk,&mask,&count,7);
            }
            else
            { dx=getbits(clusterk,&mask,&count,6);
              r=decrb(clusterk,&mask,&count,clusterd,&pos,&sekcount,dx,-1);
            }
          }
          else
          { if(!getbit(clusterk,&mask,&count))
            { clusterd[pos++]=getbits(clusterk,&mask,&count,7)|128;
            }
            else
            { dx=(!getbit(clusterk,&mask,&count)) ?
                     getbits(clusterk,&mask,&count,8)+64 :
                     getbits(clusterk,&mask,&count,12)+320;
              r=decrb(clusterk,&mask,&count,clusterd,&pos,&sekcount,dx,-1);
            }
          }
        }
        while(r==0);
        if(r==-2)
        { printk("DMSDOS: error in DS-0-2 compressed data.\n");
          return -2;
        }	
	return 0;
	
    case JM_0_0:
	do
	{ r=0;
	  if(!getbit(clusterk,&mask,&count))
	  { clusterd[pos++]=getbits(clusterk,&mask,&count,7);
	  }
	  else
	  { if(!getbit(clusterk,&mask,&count))
	    { dx=getDX(clusterk,&mask,&count);
	      r=decrb(clusterk,&mask,&count,clusterd,&pos,&sekcount,dx,0);
	    }
	    else
	    { clusterd[pos++]=getbits(clusterk,&mask,&count,7)|128;
	    }
	  }
	}
	while(r==0);
	if(r==-2)
	{ printk("DMSDOS: error in JM-0-0 compressed data.\n");
	  return -2;
	}
	return 0;
    
    default:	
	printk("DMSDOS: compression method not recognized.\n");
	return -1;
	
  } /* end switch */
  
  return 0;
}

/* read a complete file cluster and decompress it if necessary; 
   currently only called by dmsdos_file_read;
   do not use to read directory clusters (for speed reasons);
   this function is unable to read cluster 0 (CVF root directory) */
int dmsdos_read_cluster(struct super_block*sb,
                        unsigned char*clusterd, int clusternr,int cvfnr)
{	int mdfat;
	unsigned char*clusterk;
	int anz_sektoren;
	int i,j;
	struct buffer_head*bh;
	int membytes;
	int sektor;
	/*int fullsize;*/

	/*printk("DMSDOS: read_cluster %d in CVF %d\n",clusternr,cvfnr+1);*/

	mdfat=dbl_mdfat_value(sb,clusternr,cvfnr);
        sektor=(mdfat&0x1fffff)+1;
        anz_sektoren=((mdfat&0x03c00000)>>22)+1;/* real sectors on disk */
        if(anz_sektoren>dblsb[cvfnr].s_sectperclust)
        { printk("DMSDOS: read_cluster: mdfat sektors > sectperclust, cutting\n");
          anz_sektoren=dblsb[cvfnr].s_sectperclust;
        }
        
        if(mdfat&0x40000000)
        {  /* cluster is not compressed */
	   for(i=0;i<anz_sektoren;++i)
	   {  bh=read_dbl_sector(sb,sektor+i,cvfnr);
	      /*for(j=0;j<SECTOR_SIZE;++j)
	        { clusterd[i*SECTOR_SIZE+j]=bh->b_data[j];
	        }
	      */
	      memcpy(&clusterd[i*SECTOR_SIZE],bh->b_data,SECTOR_SIZE);
	      bh_free(sb,bh);
	   }
        }
        else
        {  /* cluster is compressed */
           
           /* cluster caching...disabled
           fullsize=dblsb[cvfnr].s_sectperclust*SECTOR_SIZE;
           if(ldc!=NULL&&ldc_cvfnr==cvfnr&&ldc_cnr==clusternr)
           { /printk("DMSDOS: cluster cache hit!\n");/
             for(i=0;i<fullsize;++i)clusterd[i]=ldc[i];
             return 0;
           }
           */
           
           /*printk("DMSDOS: cluster cache miss!\n");*/
        
           membytes=SECTOR_SIZE*anz_sektoren;
           
           clusterk=(unsigned char*)kmalloc(membytes,GFP_KERNEL);
           if(clusterk==NULL)
           { printk("DMSDOS: no memory for decompression!\n");
             return -2;
           }
           
           for(i=0;i<anz_sektoren;++i)
	   {  bh=read_dbl_sector(sb,sektor+i,cvfnr);
	      /*
	      for(j=0;j<SECTOR_SIZE;++j)
	      { clusterk[i*SECTOR_SIZE+j]=bh->b_data[j];
	      }
	      */
	      memcpy(&clusterk[i*SECTOR_SIZE],bh->b_data,SECTOR_SIZE);
	      bh_free(sb,bh);
	   }
	   
           i=decompress(clusterd,clusterk,mdfat);
           
           kfree_s(clusterk,membytes);
           
           if(i)
           { printk("DMSDOS: decompression of cluster %d in CVF %d failed.\n",
                    clusternr,cvfnr+1);
             return i;
           }
           
           /* cluster caching...disabled
           if(ldc!=NULL)kfree(ldc);
           ldc=(unsigned char*)kmalloc(fullsize,GFP_KERNEL);
           if(ldc==NULL)printk("DMSDOS: cluster cache: no memory, no caching\n");
           else
           { for(i=0;i<fullsize;++i)ldc[i]=clusterd[i];
             ldc_cvfnr=cvfnr;
             ldc_cnr=clusternr;
           }
           */
           
        }

	return 0;
}