#ifndef	__PAGER_H__
#define	__PAGER_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifdef	SCO
#define	ARRAY_SIZE	1
#endif

#ifndef	ARRAY_SIZE
#define	ARRAY_SIZE	0
#endif

struct	_pager;

typedef	struct	_page
{
	struct	_page	*p_nextpage;
	struct	_page	*p_prevpage;
	struct	_pager	*p_parent;
	char	p_page[ARRAY_SIZE];
}	PAGE;	

typedef	struct _pager
{
	int	c_pagelimit;
	int c_pagecount;
	int	c_pagesize;
	PAGE *c_headpage;
	PAGE *c_tailpage;
	PAGE *c_freepage;
	PAGE *(*c_fault) PROTO((struct _pager *pager));
}	PAGER;

#define	create_pager(ps, max)	attach_pager((PAGER *)malloc(sizeof(PAGER)), ps, max)
#define	destroy_pager(p)		free(detach_pager(p))
#define	assign_pagefault(p, r)	(((PAGER *)(p))->c_fault = r)

IMPORT	PAGER	*attach_pager PROTO((PAGER *def, int pagesize, int maxpages));
IMPORT	PAGER	*detach_pager PROTO((PAGER *pager));
IMPORT	void	realloc_pager PROTO((PAGER *pager));
IMPORT	PAGE	*request_page PROTO((PAGER *pager));
IMPORT	void	release_page PROTO((PAGE *page)); /* free */
IMPORT	void	return_page PROTO((PAGE *page)); /* free list */

#endif
