/*	$Header$
	Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

Created by:

	David Sugar, Tycho Softworks
   	E-Mail: dyfet@aol.com, BBS: 201-858-3429

Synopsis:

	Provides a common interface to routines which process and manipulate
	named resources.  Named resources can include names of files on the
	file system as well as names of ipc objects, memory pools, etc.

History:

	$Logs$
*/

#ifndef	__NAMES_H__
#define	__NAMES_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__BOOL_H__
#include <bool.h>
#endif

#ifdef	QNX
#include <process.h>
#define	userid()	cuserid(NULL)
#define	homedir()	chomeid(NULL)
#define	__USERID__
#endif

#ifdef	COHERENT
#include <path.h>
#define	PATH_NAME_LENGTH	MAXPATH
#endif

#ifndef	PATH_NAME_LENGTH
#define	PATH_NAME_LENGTH	128
#endif

#ifndef	FILE_NAME_LENGTH
#define	FILE_NAME_LENGTH	16
#endif

#ifndef	BASE_NAME_LENGTH
#define	BASE_NAME_LENGTH	FILE_NAME_LENGTH	
#endif

enum
{
	IPC_SHARED = 0,
	IPC_SERVER,
	IPC_MSGPORT,
	IPC_NETWORK
};

#ifndef	__USERID__
IMPORT	char	*userid PROTO((void));
IMPORT	char	*homedir PROTO((void));
#endif
IMPORT	char	*hostid PROTO((void));
IMPORT	char	*groupid PROTO((void));
IMPORT	char	*idname PROTO((char *userid));
IMPORT	BOOL	isfpath PROTO((char *path));
IMPORT	BOOL	isdevname PROTO((char *path));
IMPORT	char	*fnpath PROTO((char *buf, char *dir, char *fname));
IMPORT	char	*getfname PROTO((char *buf, char *path));
IMPORT	char	*pathfname PROTO((char *path));
IMPORT	char	*ipc_path PROTO((char *buf, char *name, int mode));
IMPORT	unsigned	ipc_keys PROTO((char *ipcname, int icpclass));
IMPORT	char	*tmpdir PROTO((void));
IMPORT	char	*spooldir PROTO((void));
IMPORT	char	*logdir PROTO((void));
IMPORT	void	begugname PROTO((void));	/* multipass session */
IMPORT	char	*getuname PROTO((unsigned uid));
IMPORT	char	*getgname PROTO((unsigned gid));
IMPORT	void	endugname PROTO((void));
#endif

