/* Hey, emacs, this is -*- C -*- code.  */

/* view.h - header for bview, gview, and pview

Copyright (C) 1992 D P Gymer

This is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later
   version.

This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.  */

/* $Id: view.h,v 0.3.2.0 1992/06/11 22:30:07 dpg Alpha dpg $ */

#ifndef VIEW_H
#define VIEW_H

/* Needed for some functions in proto.h.  */
#include <stdio.h>

/* The version identifier of this package.  */
#define VERSION	0
#define RELEASE	3
#define UPDATE	2

/* Flag which gets set to the number of the last non-terminating, caught
   signal.  */
extern int last_sig;

/* exit() status.  */
extern int rc;

/* Type and maximum value of a color component in the palette.  */
typedef unsigned char rgbval;
#define MAXRGBVAL	255

/* Type and maximum value of a palette color number.  */
typedef unsigned short COLOR;
#define MAXCOLOR	65535

/* Structure which holds a palette.  */
typedef struct palette PALETTE;
struct palette
{
  struct color
  {
    rgbval red;
    rgbval green;
    rgbval blue;
  } color;
  COLOR number;
  int count;
  PALETTE *next;
};

/* Return true iff two colors are equal. */
#define COLOREQ(p1, p2) (!memcmp(&p1, &p2, sizeof (struct color)))

/* Structure which holds a map.  */
typedef struct
{
  int width;
  int height;
  PALETTE *palette;
  COLOR **image;
} MAP;

#include "proto.h"

/* Compile-time option to use or not use the status bar.  Must come after
   prototypes.  */
#ifndef USE_STATUS_BAR
#define status_bar(x,y)
#endif

#endif /* VIEW_H */
