/* Hey, emacs, this is -*- C -*- code.  */

/* read-uxf.c - read an X-Face after it has been run through uncompface

Copyright (C) 1992 D P Gymer

This is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later
   version.

This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.  */

/* $Id: read-uxf.c,v 0.3.2.0 1992/06/11 22:30:07 dpg Alpha dpg $ */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#include "view.h"

int
maybe_read_uxface (FILE *fp, const char *file, MAP *map)
{
  int num;
  int y;
  int x;
  PALETTE *p[2];

  p[0] = alloc_palette ();
  p[1] = alloc_palette ();

  alloc_image (map, 48, 48);
  map->palette = p[0];

  p[0]->color.red = 0;
  p[0]->color.green = 0;
  p[0]->color.blue = 0;
  p[0]->number = 1;
  p[0]->count = 1;
  p[0]->next = p[1];

  p[1]->color.red = MAXRGBVAL;
  p[1]->color.green = MAXRGBVAL;
  p[1]->color.blue = MAXRGBVAL;
  p[1]->number = 0;
  p[1]->count = 1;
  p[1]->next = 0;

  x = 0;
  y = 0;
  while (fscanf (fp, "0x%4x, ", &num) == 1)
    {
      int mask = 0x8000;

      while (mask)
	{
	  int color = (num & mask) ? 1 : 0;

	  map->image[y][x++] = color;
	  /* ++p[color]->count; */
	  mask /= 2;
	}
      if (x == 48)
	{
	  ++y;
	  x = 0;
	}
    }
  return x != 0 || y != 48;
}
