/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: verbindungen.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: -
 *  Version           	: 1
 *  letzte Aenderung	: 23.03.93
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *  
 *  Exportierte Funktionen/Makros:
 * 
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *    0:  24.01.93	Verbindungs-Definitionen von fsb...h abgeloest
 *    1:  23.03.93      Verbindung um AStatus erweitert
 ********************************************************************************/
#ifndef VERBINDUNGEN_H
#define VERBINDUNGEN_H

#ifndef GRUNDTYPEN_H
#include "grundtypen.h"
#endif

#ifndef KOERPER_H
#include "koerper.h"
#endif



/****************************************************************************
 * Definitionen die Verbindungen zwischen Koerpern regeln:
 * 
 * Eine Verbindung stellt denn Zusammenhang zuwischen zwei Koerpern her.
 * Die Angabe der zwei Verbindungspunkte erfolgt in koerperfesten Koordinaten!
 * Je nach Verbindungsart sind noch die speziellen Verbindungs-Parameter
 * zu setzen!
 */

typedef enum EVerbindung { GELENK, FEDER, DAEMPFER, STANGE } TVerbindungsart ;

typedef struct TFeder {
    TReal         Ruhelaenge;
    TReal	  Federkonstante;
} TFeder;

typedef struct TDaempfer {
    TReal	  Daempfungskonstante;
} TDaempfer;

typedef struct TStange {
    TReal         Stangenlaenge;
} TStange;

typedef union TVerParameter {	/* Einflussgroessen die spezifisch fuer die */
    TFeder	  Feder;        /* jeweilige Verbindungsart sind */
    TDaempfer     Daempfer;
    TStange       Stange;
    /* das Gelenk hat keine einflussnehmenden Parameter! */
} TVerParameter;


typedef struct TVerbindung {
    struct TVerbindung     *Naechste;
    TVerbindungsart         Art;
    TKoerper               *Koerper1, *Koerper2;
    TVektor                 VPunkt1, VPunkt2;	/* in koerperfesten Koordinaten */
    TVerParameter           VerParameter;

/* 
 * AStatus ist ein Bitvektor:
 *   Bit 0: Verbindung selected (1) oder nicht (0)
 *   Bit 1: Verbindung hidden (1) oder nicht (0)
 * Hidden ist gedacht, bei der Eingabe einige Objekte zu verstecken, damit es
 * bei der Darstellung ohne verdeckte Linien nicht zu unuebersichtlich wird.
 * Inwieweit das unterstuetzt werden wird, wird sich noch zeigen.
 */

    unsigned short AStatus;		  /* Bitvektor (s.o.) */
} TVerbindung;



#endif

