/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		Kopier.c
 *  Filetyp:		Modul
 ********************************************************************************
 *  Modulname:		Kopier.c
 *  Version:		1.0
 *  letzte Aenderung:	22.03.93
 *  Autor:  		Andreas 
 *  Status:		Endzustand (hoffentlich)
 *
 *  imp. Bezeichner:	
 * 
 *  exp. Bezeichner:
 *
 *  Fehler:
 *  -------
 *  										
 *  Beschreibung:								
 *  -------------								
 *										
 *  Versionsgeschichte:								
 *  -------------------								
 *   21.12.92: Grundger"ust der Kopierroutine
 *   08.01.93: Verbesserung von Fehlern (hoffentlich)
 *   03.02.93: Anpassung an das Kopieren von zusammengesetzten Objekten
 *   10.02.93: Anpassung an erweiterte Objektdefinitionen wie Farbe, Status.
 *   11.02.93: Eine von Horst's privaten Variablen mu"s auch kopiert werden.
 *   15.03.93: Kopieren der Kr"afte wird unterst"utzt.
 *   22.03.93: Kopieren des Wertes Angriffsflche (Luftwiderstand).
 ********************************************************************************/

#include "Welt.h"


static void sucheKoerper( TZustand *ZustandsKopie, TZustand *ZustandsOriginal, 
			  TKoerper **Kopie, TKoerper *Original )
{
   TKoerper *KopieHangel, *OriginalHangel;
   TBoolean NotFound = TRUE;

   OriginalHangel = ZustandsOriginal->Koerper;
   KopieHangel = ZustandsKopie->Koerper;
   while( (OriginalHangel != NULL) && ( NotFound ) )
   {
      if( OriginalHangel == Original )
      {
         *Kopie = KopieHangel;
         NotFound = FALSE;
      } 
      else 
      {
         OriginalHangel = OriginalHangel->Naechster;
         KopieHangel = KopieHangel->Naechster;
      }
   }
}


void KraftKopieren( TZustand *ZustandsKopie, TZustand *ZustandsOriginal, 
		    TKraft **Kopie, TKraft *Original )
{
   if( Original != NULL )
   {
      *Kopie = (TKraft *) malloc( sizeof(TKraft) );
      SpeicherFrei( *Kopie );
      (*Kopie)->Typ = Original->Typ;
      (*Kopie)->StartZeit = Original->StartZeit;
      (*Kopie)->EndZeit = Original->EndZeit;
      (*Kopie)->Angriffspunkt[0] = Original->Angriffspunkt[0];
      (*Kopie)->Angriffspunkt[1] = Original->Angriffspunkt[1];
      (*Kopie)->Angriffspunkt[2] = Original->Angriffspunkt[2];
      (*Kopie)->KD = Original->KD;
      if( Original->Typ == GERICHTET )
	 sucheKoerper( ZustandsKopie, ZustandsOriginal, &(*Kopie)->KD.GerKraft.ZielKoerper, 
		       Original->KD.GerKraft.ZielKoerper );
      KraftKopieren( ZustandsKopie, ZustandsOriginal, &(*Kopie)->Naechste, 
		     Original->Naechste );
   }
   else 
      *Kopie = NULL;
}


void KopiereKraefte( TZustand *ZustandsKopie, TZustand *ZustandsOriginal, 
                     TKoerper *Kopie, TKoerper *Original )
{
   while( Original != NULL )
   {
      if( Original->Kraefte != NULL )
	 KraftKopieren( ZustandsKopie, ZustandsOriginal, &Kopie->Kraefte, Original->Kraefte );
      Original = Original->Naechster;
      Kopie = Kopie->Naechster;
   }
}


void KopiereKoerper( TKoerper **Kopie, TKoerper *Original, TKoerper *Ober )
{
   if( Original != NULL )
   {   
      *Kopie = (TKoerper *) malloc( sizeof(TKoerper) );
      SpeicherFrei( *Kopie );
	 
      if( Ober == NULL )
	 KoerperKopieren( *Kopie, Original, *Kopie );
      else 
	 KoerperKopieren( *Kopie, Original, Ober );
      if( Original->Art == ZUSGESOBJ )
	 KopiereKoerper( &(*Kopie)->Form.ZusGesObj.KoerperListe, 
                         Original->Form.ZusGesObj.KoerperListe, *Kopie );
      if( Original->Naechster != NULL )
	 if( Ober == NULL )
	    KopiereKoerper( &(*Kopie)->Naechster, Original->Naechster, NULL );
	 else KopiereKoerper( &(*Kopie)->Naechster, Original->Naechster, Ober );
      else (*Kopie)->Naechster = NULL;
   } 
   else 
      *Kopie = NULL;
}



static void KopiereVerbindung( TZustand *ZustandsKopie, TZustand *ZustandsOriginal,
			       TVerbindung **Kopie, TVerbindung *Original )
{
   int i;

   if( Original != NULL )
   {
      *Kopie = (TVerbindung *) malloc( sizeof(TVerbindung) );
      SpeicherFrei( *Kopie );
      (*Kopie)->Art = Original->Art;
      for( i=0; i<=2; i++ )
      {  
         (*Kopie)->VPunkt1[i] = Original->VPunkt1[i];
         (*Kopie)->VPunkt2[i] = Original->VPunkt2[i];
      }
      (*Kopie)->VerParameter = Original->VerParameter;
      (*Kopie)->AStatus = Original->AStatus;
      sucheKoerper( ZustandsKopie, ZustandsOriginal, &(*Kopie)->Koerper1, Original->Koerper1 );
      sucheKoerper( ZustandsKopie, ZustandsOriginal, &(*Kopie)->Koerper2, Original->Koerper2 );
      KopiereVerbindung( ZustandsKopie, ZustandsOriginal, &(*Kopie)->Naechste, Original->Naechste );
   } else *Kopie = NULL;
}


void KopiereZustand( TZustand *Kopie, TZustand *Original )
{
   int i;
   
   if( Original != NULL )
   {
      Kopie->Zeit = Original->Zeit;
      for( i=0; i<=2; i++ )
	 Kopie->GravitationsVektor[i] = Original->GravitationsVektor[i];
      Kopie->GravitationAn = Original->GravitationAn;
      Kopie->Seed = Original->Seed;                      /* 03.03.93 */
      Kopie->MaterialDaten = Original->MaterialDaten;
      KopiereKoerper( &Kopie->Koerper, Original->Koerper, NULL );
      KopiereVerbindung( Kopie, Original, &Kopie->Verbindungen, Original->Verbindungen ); /* */
      KopiereKraefte( Kopie, Original, Kopie->Koerper, Original->Koerper );
   }
   else fprintf( stderr,"Something went wrong in KopiereZustand!");
}


/*******************************************************************************
 *  void KopiereWelt( TWelt *lastSync, TWelt *aktuelleWelt )
 *  TWelt *lastSync
 *  TWelt *aktuelleWelt
 *										
 *  Fehler:  (Beschreibung evtl. Fehlerwerte im Resultatsparameter)		
 *										
 *  Beschreibung:								
 *  -------------								
 *
 ********************************************************************************/

void KopiereWelt( TWelt **Kopie, TWelt *Original )
{
   if( Original != NULL )
   {
      *Kopie = (TWelt *) malloc( sizeof(TWelt) );
      SpeicherFrei( *Kopie )   /* #define SpeicherFrei ... == NULL ... */

      (*Kopie)->FrameCounter = Original->FrameCounter;
      (*Kopie)->prevSync = Original->prevSync;
      (*Kopie)->thisSync = Original;
      (*Kopie)->nextSync = Original->nextSync;
      (*Kopie)->SzenenAnfang = Original->SzenenAnfang;
      KopiereZustand( &(*Kopie)->Welt, &Original->Welt );
   }
   else fprintf( stderr,"Something went wrong in KopiereWelt\n");
}


static void entferneKraefte( TKraft **Original )
{
   if( *Original != NULL )
   {
      entferneKraefte( &(*Original)->Naechste );
      free( *Original );
      *Original = NULL;
   }
}


static void entferneVerbListe( TVerbindung **Original )
{
   if( *Original != NULL )
   {
      entferneVerbListe( &(*Original)->Naechste );
      free( *Original );
      *Original = NULL;
   }
}


static void entferneObjListe( TKoerper **Original )
{
   if( *Original != NULL )
   {
      if( (*Original)->Art == ZUSGESOBJ )
	 entferneObjListe( &(*Original)->Form.ZusGesObj.KoerperListe );
      entferneObjListe( &(*Original)->Naechster );
      entferneKraefte( &(*Original)->Kraefte );
      free( *Original );
      *Original = NULL;
   }
}


void entferneZustand( TZustand *Original )
{
   entferneObjListe( &Original->Koerper );
   entferneVerbListe( &Original->Verbindungen );
}


void entferneWelt( TWelt **Original )
{
   entferneZustand( &(*Original)->Welt );
   free( *Original );
   *Original = NULL;
}

