/********************************************************************************
 *  Projektname:        AERO
 *  Filename:           Editor.c
 *  Filetyp:            Modul
 ********************************************************************************
 *  Modulname:          Editor
 *  Version:            1.1
 *  letzte Aenderung:   10.03.94
 *  Autor:              Andreas
 *  Status:             finished, only bugs will be fixed
 *
 *  imp. Bezeichner:
 *
 *  exp. Bezeichner:    Widget topLevel
 *                      Widget EM_paneBox
 *                      Widget GD_Dialog
 *
 *  Beschreibung:
 *  -------------
 *
 *  Fehler:
 *  -------
 *
 *  Versionsgeschichte:
 *  -------------------
 *  -2.12.92: Bereitstellen von Editor-Funktionalit"aten
 *   3.12.92: Hinzuf"ugen von Funktionalit"aten. Die neuesObjekt Funktionalt"at
 *            wird entwickelt und Ggobale Datentypen, die die Welt beschreiben,
 *            eingef"ugt.
 *   9.12.92: Einh"angen einer Darstellungsroutine
 *  11.12.92: Das Darstellungsfenster wird in vier Teilfenster untergliedert,
 *            die Darstellungsroutine daf"ur in das Animationsfenster "uber-
 *            nommen.
 *  26.01.93: Hinzuf"ugen der Funktionalit"at 'selektiere Objekt' statt 'entferne
 *            Objekt'. Dazu wird ein Men"u angeh"angt, das die Funktionalit"at
 *            des 'entferne Objekt' beinhaltet und zus"atzlich das Edieren von
 *            Objekten gestattet.
 *  12.03.93: Kraftmenu kommt hinzu
 * -24.06.93: Scrollen ist nun auch im Editor m"oglich.
 *  26.07.93: SelektFirst-Button nun auch erh"altlich.
 *  10.03.94: Deklaration und Initialisierung der Variablen raytracerVersion
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Repeater.h>

#include <string.h>
#include "Welt.h"
#include "rayausg.h"
#include "bitmap/rotXP.xbm"
#include "bitmap/rotXM.xbm"
#include "bitmap/rotYP.xbm"
#include "bitmap/rotYM.xbm"
#include "bitmap/rotZP.xbm"
#include "bitmap/rotZM.xbm"
#include "bitmap/movXP.xbm"
#include "bitmap/movXM.xbm"
#include "bitmap/movYP.xbm"
#include "bitmap/movYM.xbm"
#include "bitmap/movZP.xbm"
#include "bitmap/movZM.xbm"
#include "bitmap/xaero.xbm"


/********************************************************************************
 * Externe Prozeduren, die hier zu Bindungszwecken definiert sein mssen.
 ********************************************************************************/
   extern  void installMenu (void);
   extern  void installKamera (void);
   extern  void installBestimmeDateiname (void);
   extern  void installNeuesMaterial (void);
   extern  void installMaterialDaten (void);
   extern  void LeseSequenz (char *, TBoolean);
   extern  void initGZObjekt (Widget, XtPointer, XtPointer);
   extern  void loeseGruppe (Widget, XtPointer, XtPointer);
   extern  void installGruppiereZusammengestztesObjekt (void);
   extern  void KameraDefaults (Widget, XtPointer, XtPointer);
   extern  void entbindeKamera (Widget, XtPointer, XtPointer);

   /*****************************************************************************
    * von Modul Kraft.c
    *****************************************************************************/
   extern  void installKraftBetrag();
   extern  void installAngriffsPunkt();
   extern  void installRichtungsVektor();

   /*****************************************************************************
    * von Modul Animation.c
    *****************************************************************************/
   extern  void SequenzRechneAnzeige (Widget, XtPointer, XtPointer);
   extern  void NextAnimation (Widget, XEvent *, String *, Cardinal *);
   extern  void installAnimationWindow (void);  
   extern  void SetzeActionsAnimation (XtAppContext *, Widget);
   extern  void berechneSequenz (char *, int);
 
   /*****************************************************************************
    * von Modul Objektaktionen.c
    *****************************************************************************/
   extern  void ObjectInsertion (Widget, XtPointer, XtPointer);
   extern  void inc (Widget, XEvent *, String *, Cardinal *);
   extern  void dec (Widget, XEvent *, String *, Cardinal *);
   extern  void scrollFenster (Widget, XEvent *, String *, Cardinal *);
   extern  void positioniereObjekt (Widget, XEvent *, String *, Cardinal *);
   extern  void selektiereAuswahlNext (Widget, XtPointer, XtPointer);
   extern  void Aktion_entferneObjekt (Widget, XtPointer, XtPointer);
   extern  void VerbInsertion (Widget, XtPointer, XtPointer);
   extern  void installObjektAktionen (void);
   extern  void installSelektAuswahl (void);
   extern  void installVerbindungAufbau (void);
   extern  void installVerbindungsPosition (void);
   extern  void installAendereVerbindung (void);
   extern  void DZoomPlus (Widget, XtPointer, XtPointer);
   extern  void DZoomMinus (Widget, XtPointer, XtPointer);
   extern  void VerbLoeschen (Widget, XtPointer, XtPointer);
   extern  void KraefteLoeschen (Widget, XtPointer, XtPointer);
   extern  void VerbAendern (Widget, XtPointer, XtPointer);
   extern  void initKraft (Widget, XtPointer, XtPointer);
   extern  void bindeKameraAnKoerper (Widget, XtPointer, XtPointer);
   extern  void selektiereErstesObjekt (Widget, XtPointer, XtPointer);

   /******************************************************************************
    * von Modul anzeige.c und animat.c (Hartmut)
    ******************************************************************************/
   extern  void InitialisiereAnimation (XtAppContext *, Widget);
   extern  void InitialisiereDarstellung (Widget, Widget, Widget, Widget);
   extern  void SetzeActionsDarstellung (XtAppContext *, Widget, Widget, Widget, Widget);
   extern  void AnzeigeDarstellung (Widget, Widget, Widget, Widget, TVektor, TQuaternion, 
				    TReal, TZustand *, int);


/********************************************************************************
 * Globale Widgets. K"onnen leider aus Gr"unden der Parameter"ubergabe nicht nur
 * lokal verwendet werden. Sie werden teilweise noch an anderer Stelle gebraucht.
 *    ApplicationContext wird ebenfalls global definiert, da in mehreren Modulen
 * darauf zugegriffen wird. (Die initialiesierung von Actions mu"s dann nicht
 * immer in main() erfolgen.
 ********************************************************************************/
Widget topLevel, EM_paneBox, EM_DarstBox, EM_DarstellungXY, EM_DarstellungYZ, 
       EM_DarstellungXZ, EM_Darstellung3D, EM_neuesObjekt, EM_step, EM_selektObjekt,
       EM_entferneObjekt, EM_angreifKraft, /* EM_veraenderKraft, */ EM_gotoAnimation, 
       EM_Verbindung, EM_ladeMatTab, AW_Animation, AW_Shell, AW_box, AW_Pause, AW_Play, 
       AW_prevSync, AW_Step, AW_toggleSync, AW_nextSync, AW_firstSync, AW_lastSync, 
       AW_Close, AW_neueSzene, AW_toggleSzenenAnfang, AW_FrameCnt, AW_Kamera, 
       AW_Raytracing, GD_Dialog, AA_Shell, BPS_Dialog, BPS_Interaktion, VC_Menu, 
       OC_Menu, KM_Menu, NO_Shell, NO_Apply, NO_Param1, NO_Material, NO_Param2, 
       NO_Param3, NO_Param1Txt, NO_Param2Txt, NO_Param3Txt, NO_rotXP, NO_rotXM, 
       NO_rotYP, NO_rotYM, NO_rotZP, NO_rotZM, NO_movXP, NO_movXM, NO_movYP, 
       NO_movYM, NO_movZP, NO_movZM, SA_Shell, SA_label, SA_Next, SA_Apply, 
       VA_DialogDaempfer, VA_InteraktDaempfer, VA_ShellFeder, VA_RuheFeder, 
       VA_KonstFeder, KW_Shell, SO_Menu, NO_ObjektInfo, VP_Shell, EM_KoordDarstOnOff, 
       QD_Shell, NO_Pos_X, NO_Pos_Y, NO_Pos_Z, NO_ScrollRot, NO_ScrollGruen, 
       NO_ScrollBlau, NO_Undo, NO_ResetRot, NO_ResetMov, NO_Farbe, EM_entferneVerb, 
       EM_aenderVerb, AV_Shell, AV_VerbInfo, AV_K1X, AV_K1Y, AV_K1Z, AV_K2X, AV_K2Y, 
       AV_K2Z, AV_Param1Txt, AV_Param1, AV_Param2Txt, AV_Param2, AV_Apply, AV_Abort, 
       BD_Shell, BD_Name, BD_List, NO_DurchsichtTxt, NO_Durchsicht, NO_DurchsProz, 
       NO_neuesMat, NO_showMat, NO_GravLos, NO_MasseLos, EM_entbindeKamera, EM_bindeKamera,
       EM_loescheKraefte, EM_Gruppe, EM_loeseGruppe, EM_selektFirst;

XtAppContext appContext;
TVektor Koordinatenursprung;
TReal DZoomFaktor;
TQuaternion Ausrichtung;      /* Kameraschwenk im Darstellungsfenster */
TKamera AnimKamera;
TBoolean AnimKameraOpen;
long KoerperId;
int KoordAnAus, KraefteAnAus, KoerperKoordAnAus, dreiD, raytracerVersion;
TQuaternion CRotXP = {0.99904822,  0.043619387, 0.0, 0.0};
TQuaternion CRotXM = {0.99904822, -0.043619387, 0.0, 0.0};
TQuaternion CRotZP = {0.99904822, 0.0, 0.0,  0.043619387};
TQuaternion CRotZM = {0.99904822, 0.0, 0.0, -0.043619387};
TQuaternion CRotYP = {0.99904822, 0.0,  0.043619387, 0.0};
TQuaternion CRotYM = {0.99904822, 0.0, -0.043619387, 0.0};
String MaterialienListe2[] = {"Eisen", "Plastik", "Light", NULL};
String *MaterialienListe;
Pixmap mark;
Pixmap BRotXP, BRotXM, BRotYP, BRotYM, BRotZP, BRotZM;
Pixmap BMovXP, BMovXM, BMovYP, BMovYM, BMovZP, BMovZM, BXaeroIcon;
char *raytracedFile = "AERO";

extern int   kb_debug_level;
extern int   s_debug_level;
extern int   fsb_debug_level; 


/********************************************************************************
 *  Globale Parameter. Aufgrund der Struktur der XWindow-Programme k"fonnen keine
 *  Parameter "ubergeben werden. Deshalb mssen sie global gehalten werden.
 ********************************************************************************/
TWelt *firstSync, *lastSync, *aktuelleWelt;
TKoerper *selektiertesObjekt;
TReal ZeitIncrement;


/*****************************************************************************
 *****************************************************************************/
void DStep (Widget w, XtPointer a, XtPointer b)
{
   FolgeBildBerechnung (&aktuelleWelt->Welt, ZeitIncrement);
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
		       EM_Darstellung3D, Koordinatenursprung, Ausrichtung, 
                       DZoomFaktor, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


static void DDecKamera (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TReal schrittW = 0.5/DZoomFaktor;

   switch ((TRichtung) Richtung)
   {
      case XRich: Koordinatenursprung[0] -= schrittW;
                  break;
      case YRich: Koordinatenursprung[1] -= schrittW;
                  break;
      case ZRich: Koordinatenursprung[2] += schrittW;
                  break;
   }
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
		       EM_Darstellung3D, Koordinatenursprung, Ausrichtung, 
                       DZoomFaktor, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


static void DIncKamera (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TReal schrittW = 0.5/DZoomFaktor;

   switch ((TRichtung) Richtung)
   {
      case XRich: Koordinatenursprung[0] += schrittW;
                  break;
      case YRich: Koordinatenursprung[1] += schrittW;
                  break;
      case ZRich: Koordinatenursprung[2] -= schrittW;
                  break;
   }
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
		       EM_Darstellung3D, Koordinatenursprung, Ausrichtung, 
                       DZoomFaktor, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


static void DDefault (Widget w, XtPointer muell, XtPointer garbage)
{
   Koordinatenursprung[0] = 0.0;
   Koordinatenursprung[1] = 0.0;
   Koordinatenursprung[2] = 0.0;
   DZoomFaktor = 1.0;
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
		       EM_Darstellung3D, Koordinatenursprung, Ausrichtung, 
                       DZoomFaktor, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  static void Quit (Widget w, XEvent *event, String *params, Cardinal *num_params)
 *  3. String *params: Parameterliste, die in der Translationtable stehen.
 *
 *  Beschreibung:
 *  -------------
 *  Die Prozedur Quit bringt ein Fenster an der aktuellen Mausposition zum Vor-
 *  schein (es wird nicht die Mausposition, sondern das aufrufende Widget als
 *  bezugspunkt gew"ahlt). Der Benutzer wird nach einer Best"atigung seines
 *  Wunsches, den Editor zu verlassen gefragt.
 ********************************************************************************/

static void Quit (Widget w, XEvent *event, String *params, Cardinal *num_params)
{
   XKeyEvent *key;
   Position x, y;
   Dimension width, height;

   exit (0);       /* auskommentieren, wenn nicht mehr ben"otigt */
   x = 0; y = 0; width = 0; height = 0;

   key = (XKeyEvent *) event;
   XtVaGetValues (QD_Shell, XtNwidth, &width, XtNheight, &height, NULL);
   
   if (width == 0)
   {
      XtRealizeWidget (QD_Shell);
      XtVaGetValues (QD_Shell, XtNwidth, &width, XtNheight, &height, NULL);
   }
   y = key->y_root-(height/2);
   x = key->x_root-(width/2);
   if (QD_Shell != NULL)
   {
      XtVaSetValues (QD_Shell, XtNx, x, XtNy, y, NULL);
      XtPopup (QD_Shell, XtGrabExclusive);
   }
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void QuitConfirm (Widget w, XtPointer clientData, XtPointer callData)
{
   XtPopdown ((Widget) clientData);
   XtDestroyApplicationContext (appContext);
   exit (0);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void QuitAborted (Widget w, XtPointer clientData, XtPointer callData)
{
   XtPopdown ((Widget) clientData);
}


/*******************************************************************************
 *  void installMoreEditorFunctions (void)
 *
 *  Fehler:  (Beschreibung evtl. Fehlerwerte im Resultatsparameter)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine installiert weiter Buttons und Menues.
 ********************************************************************************/

void installMoreEditorFunctions (void)
{
   Widget QD_Abort, QD_Quit, QD_Text, QD_Box, OC_Kugel, OC_Ebene,
          OC_Quader, OC_Zylinder, /*OC_Punkt,*/ OC_Nagel, VC_Stange, VC_Feder,
          VC_Daempfer, VC_Gelenk, KM_Raumfest, KM_Koerperfest, 
          KM_Gerichtet;

   /*****************************************************************************
    * Es folgt das Auswahlmenue f"ur die verschiedenen Objektarten
    *****************************************************************************/
   OC_Menu = XtVaCreatePopupShell("OC_Menu", simpleMenuWidgetClass, topLevel, NULL);
   OC_Kugel = XtVaCreateManagedWidget("line", smeLineObjectClass, OC_Menu, NULL);
   OC_Kugel = XtVaCreateManagedWidget("OC_Kugel", smeBSBObjectClass, OC_Menu, NULL);
   OC_Quader = XtVaCreateManagedWidget("OC_Quader", smeBSBObjectClass, OC_Menu, NULL);
   OC_Zylinder = XtVaCreateManagedWidget("OC_Zylinder", smeBSBObjectClass, OC_Menu, NULL);
   OC_Ebene = XtVaCreateManagedWidget("OC_Ebene", smeBSBObjectClass, OC_Menu, NULL);
   OC_Nagel = XtVaCreateManagedWidget("OC_Nagel", smeBSBObjectClass, OC_Menu, NULL);
   XtAddCallback (OC_Kugel, XtNcallback, ObjectInsertion, (XtPointer) KUGEL);
   XtAddCallback (OC_Quader, XtNcallback, ObjectInsertion, (XtPointer) QUADER);
   XtAddCallback (OC_Zylinder, XtNcallback, ObjectInsertion, (XtPointer) ZYLINDER);
   XtAddCallback (OC_Ebene, XtNcallback, ObjectInsertion, (XtPointer) EBENE);
   XtAddCallback (OC_Nagel, XtNcallback, ObjectInsertion, (XtPointer) NAGEL);

   /*****************************************************************************
    * Es folgt das Auswahlmenue f"ur die verschiedenen Kraftarten
    *****************************************************************************/
   KM_Menu = XtVaCreatePopupShell("KM_Menu", simpleMenuWidgetClass, topLevel, NULL);
   KM_Raumfest = XtVaCreateManagedWidget("KM_Raumfest", smeBSBObjectClass, KM_Menu, NULL);
   KM_Koerperfest = XtVaCreateManagedWidget("KM_Koerperfest", smeBSBObjectClass, KM_Menu, NULL);
   KM_Gerichtet = XtVaCreateManagedWidget("KM_Gerichtet", smeBSBObjectClass, KM_Menu, NULL);
   XtAddCallback (KM_Raumfest, XtNcallback, initKraft, (XtPointer) RAUMFEST);
   XtAddCallback (KM_Koerperfest, XtNcallback, initKraft, (XtPointer) KOERPERFEST);
   XtAddCallback (KM_Gerichtet, XtNcallback, initKraft, (XtPointer) GERICHTET);

   /*****************************************************************************
    * Es folgt das Auswahlmenue f"ur die verschiedenen Verbindungsarten
    *****************************************************************************/
   VC_Menu = XtVaCreatePopupShell("VC_Menu", simpleMenuWidgetClass, topLevel, NULL);
   VC_Stange = XtVaCreateManagedWidget("line", smeLineObjectClass, VC_Menu, NULL); 
   VC_Stange = XtVaCreateManagedWidget("VC_Stange", smeBSBObjectClass, VC_Menu, NULL);
   XtAddCallback (VC_Stange, XtNcallback, VerbInsertion, (XtPointer) STANGE); 
   VC_Feder = XtVaCreateManagedWidget("VC_Feder", smeBSBObjectClass, VC_Menu, NULL);
   XtAddCallback (VC_Feder, XtNcallback, VerbInsertion, (XtPointer) FEDER); 
   VC_Daempfer = XtVaCreateManagedWidget("VC_Daempfer", smeBSBObjectClass, VC_Menu, NULL);
   XtAddCallback (VC_Daempfer, XtNcallback, VerbInsertion, (XtPointer) DAEMPFER); 
   VC_Gelenk = XtVaCreateManagedWidget("VC_Gelenk", smeBSBObjectClass, VC_Menu, NULL);
   XtAddCallback (VC_Gelenk, XtNcallback, VerbInsertion, (XtPointer) GELENK); 


   /*****************************************************************************
    * Es folgt die Installation des Quit-Dialoges
    *****************************************************************************/
   QD_Shell = XtVaCreatePopupShell("QD_Shell", transientShellWidgetClass, topLevel, NULL);
   QD_Box = XtVaCreateManagedWidget("QD_Box", formWidgetClass, QD_Shell, NULL);
   QD_Text = XtVaCreateManagedWidget("QD_Text", labelWidgetClass, QD_Box, NULL);
   QD_Quit = XtVaCreateManagedWidget("QD_Quit", commandWidgetClass, QD_Box, NULL);
   QD_Abort = XtVaCreateManagedWidget("QD_Abort", commandWidgetClass, QD_Box, NULL);
   XtAddCallback (QD_Quit, XtNcallback, QuitConfirm, (XtPointer) QD_Shell);
   XtAddCallback (QD_Abort, XtNcallback, QuitAborted, (XtPointer) QD_Shell);
}


/*******************************************************************************
 *  void installEditor (void)
 *
 *  Beschreibung:
 *  -------------
 *  Installiert das Editorfenster mit seinen Buttons, Sub-Menues, ...
 *  Es werden dabei die globalen Widget-Variablen initialisiert.
 *  Das Resource-File legt das endgltige Aussehen des Editors fest.
 ********************************************************************************/

void installEditor (void)
{
   Widget EM_box, EM_ZoomPlus, EM_ZoomMinus, EM_l, EM_r, EM_u, EM_d, EM_f, EM_b,
          EM_default;
   XtActionsRec darstActions[] = {
                   {"inc", inc},
                   {"dec", dec},
                   {"scrollFenster", scrollFenster},
                   {"positioniereObjekt", positioniereObjekt},
                };


   EM_box = XtVaCreateManagedWidget("EM_box", formWidgetClass, EM_paneBox, NULL);
   EM_DarstBox = XtVaCreateManagedWidget("EM_DarstBox", formWidgetClass, EM_box, NULL);

   /*****************************************************************************
    * Ein neu eingef"ugtes Objekt mu"s noch positioniert werden. Dazu mssen die
    * Routinen inc, dec und wechselFenster zur Verfgung gestellt werden.
    *   Die Translation-Tabelle wird erst beim Aufruf der Positionierungs-Routine
    * installiert.
    *****************************************************************************/
   XtAppAddActions (appContext, darstActions, XtNumber (darstActions));

   EM_DarstellungXY = XtVaCreateManagedWidget("EM_DarstellungXY", simpleWidgetClass, EM_DarstBox, NULL);
   EM_DarstellungYZ = XtVaCreateManagedWidget("EM_DarstellungYZ", simpleWidgetClass, EM_DarstBox, NULL);
   EM_DarstellungXZ = XtVaCreateManagedWidget("EM_DarstellungXZ", simpleWidgetClass, EM_DarstBox, NULL);
   EM_Darstellung3D = XtVaCreateManagedWidget("EM_Darstellung3D", simpleWidgetClass, EM_DarstBox, NULL);

   EM_neuesObjekt    = XtVaCreateManagedWidget("EM_neuesObjekt",    menuButtonWidgetClass, EM_box, NULL);
   EM_selektObjekt   = XtVaCreateManagedWidget("EM_selektObjekt",   commandWidgetClass,    EM_box, NULL);
   EM_selektFirst    = XtVaCreateManagedWidget("EM_selektFirst",    commandWidgetClass,    EM_box, NULL);
   EM_entferneObjekt = XtVaCreateManagedWidget("EM_entferneObjekt", commandWidgetClass,    EM_box, NULL);
   EM_angreifKraft   = XtVaCreateManagedWidget("EM_angreifKraft",   menuButtonWidgetClass, EM_box, NULL);
/*   EM_veraenderKraft = XtVaCreateManagedWidget("EM_veraenderKraft", commandWidgetClass,    EM_box, NULL); */
   EM_loescheKraefte = XtVaCreateManagedWidget("EM_loescheKraefte", commandWidgetClass,    EM_box, NULL);
   EM_Verbindung     = XtVaCreateManagedWidget("EM_Verbindung",     menuButtonWidgetClass, EM_box, NULL);
   EM_entferneVerb   = XtVaCreateManagedWidget("EM_entferneVerb",   commandWidgetClass,    EM_box, NULL);
   EM_aenderVerb     = XtVaCreateManagedWidget("EM_aenderVerb",     commandWidgetClass,    EM_box, NULL);
   EM_Gruppe         = XtVaCreateManagedWidget("EM_Gruppe",         commandWidgetClass,    EM_box, NULL);
   EM_loeseGruppe    = XtVaCreateManagedWidget("EM_loeseGruppe",    commandWidgetClass,    EM_box, NULL);
   EM_bindeKamera    = XtVaCreateManagedWidget("EM_bindeKamera",    commandWidgetClass,    EM_box, NULL);
   EM_entbindeKamera = XtVaCreateManagedWidget("EM_entbindeKamera", commandWidgetClass,    EM_box, NULL);
   EM_ZoomPlus       = XtVaCreateManagedWidget("EM_ZoomPlus",       repeaterWidgetClass,   EM_box, NULL);
   EM_ZoomMinus      = XtVaCreateManagedWidget("EM_ZoomMinus",      repeaterWidgetClass,   EM_box, NULL);
   EM_l = XtVaCreateManagedWidget("EM_l",    commandWidgetClass,    EM_box, NULL);
   EM_d = XtVaCreateManagedWidget("EM_d",    commandWidgetClass,    EM_box, NULL);
   EM_b = XtVaCreateManagedWidget("EM_b",    commandWidgetClass,    EM_box, NULL);
   EM_r = XtVaCreateManagedWidget("EM_r",    commandWidgetClass,    EM_box, NULL);
   EM_u = XtVaCreateManagedWidget("EM_u",    commandWidgetClass,    EM_box, NULL);
   EM_f = XtVaCreateManagedWidget("EM_f",    commandWidgetClass,    EM_box, NULL);
   EM_default = XtVaCreateManagedWidget("EM_default", commandWidgetClass, EM_box, NULL);

   EM_step           = XtVaCreateManagedWidget("EM_step",           repeaterWidgetClass,   EM_box, NULL);
   EM_gotoAnimation  = XtVaCreateManagedWidget("EM_gotoAnimation",  commandWidgetClass,    EM_box, NULL);

   XtAddCallback (EM_selektObjekt, XtNcallback, selektiereAuswahlNext, NULL);
   XtAddCallback (EM_selektFirst, XtNcallback, selektiereErstesObjekt, NULL);
   XtAddCallback (EM_entferneObjekt, XtNcallback, Aktion_entferneObjekt, NULL);
   XtAddCallback (EM_loescheKraefte, XtNcallback, KraefteLoeschen, NULL);
   XtAddCallback (EM_entferneVerb, XtNcallback, VerbLoeschen, NULL);
   XtAddCallback (EM_aenderVerb, XtNcallback, VerbAendern, NULL);
   XtAddCallback (EM_Gruppe, XtNcallback, initGZObjekt, NULL); 
   XtAddCallback (EM_loeseGruppe, XtNcallback, loeseGruppe, NULL);
   XtAddCallback (EM_gotoAnimation, XtNcallback, SequenzRechneAnzeige, (XtPointer) FALSE);
   XtAddCallback (EM_bindeKamera, XtNcallback, bindeKameraAnKoerper, NULL);
   XtAddCallback (EM_entbindeKamera, XtNcallback, entbindeKamera, NULL);
   XtAddCallback (EM_entbindeKamera, XtNcallback, KameraDefaults, (XtPointer) FALSE);
   XtAddCallback (EM_ZoomPlus, XtNcallback, DZoomPlus, NULL);
   XtAddCallback (EM_ZoomMinus, XtNcallback, DZoomMinus, NULL);
   XtAddCallback (EM_l, XtNcallback, DDecKamera, (XtPointer) XRich);
   XtAddCallback (EM_d, XtNcallback, DDecKamera, (XtPointer) YRich);
   XtAddCallback (EM_b, XtNcallback, DDecKamera, (XtPointer) ZRich);
   XtAddCallback (EM_r, XtNcallback, DIncKamera, (XtPointer) XRich);
   XtAddCallback (EM_u, XtNcallback, DIncKamera, (XtPointer) YRich);
   XtAddCallback (EM_f, XtNcallback, DIncKamera, (XtPointer) ZRich);
   XtAddCallback (EM_default, XtNcallback, DDefault, NULL);
   XtAddCallback (EM_step, XtNcallback, DStep, NULL);
}


void initWelt (void)
{
   aktuelleWelt = (TWelt *) malloc (sizeof(TWelt));
   SpeicherFrei (aktuelleWelt);
   
   raytracerVersion = POVRAY2; /* Default-raytracer: POVray 2.x */
   aktuelleWelt->Welt.Zeit = 0.0;
   aktuelleWelt->Welt.Koerper = NULL;
   aktuelleWelt->Welt.Verbindungen = NULL;
   aktuelleWelt->Welt.GravitationsVektor[0] = 0.0;
   aktuelleWelt->Welt.GravitationsVektor[1] = -9.81;
   aktuelleWelt->Welt.GravitationsVektor[2] = 0.0;
   aktuelleWelt->Welt.GravitationAn = TRUE;
   aktuelleWelt->Welt.MaterialDaten = &GrundMaterialien;
   aktuelleWelt->FrameCounter = 1;    /* oder 0 */
   aktuelleWelt->prevSync = NULL;
   aktuelleWelt->nextSync = NULL;
   KoerperId = 0;
   firstSync = NULL;
   lastSync = NULL;
   selektiertesObjekt = NULL;
   ZeitIncrement = 1.0/25.0;   
   Ausrichtung[0] = 1.0;
   Ausrichtung[1] = 0.0;
   Ausrichtung[2] = 0.0;
   Ausrichtung[3] = 0.0;
   DZoomFaktor = 1.0;
   Koordinatenursprung[0] = 0.0;
   Koordinatenursprung[1] = 0.0;
   Koordinatenursprung[2] = 0.0;

   AnimKamera.Position[0] =  1.4;
   AnimKamera.Position[1] =  1.4;
   AnimKamera.Position[2] = 5.0;
   AnimKamera.Richtung[0] = 0.98296290395980601;
   AnimKamera.Richtung[1] = 0.12940952045410214;
   AnimKamera.Richtung[2] = -0.12940952045410217;
   AnimKamera.Richtung[3] = -0.017037086462466818;
   AnimKamera.Zoom = 1.0;
   AnimKamera.Offset[0] = 0.0;
   AnimKamera.Offset[1] = 0.0;
   AnimKamera.Offset[2] = 0.0;
   AnimKameraOpen = FALSE;
   MaterialienListe = (String *) MaterialNamen (aktuelleWelt->Welt.MaterialDaten);
}



void installBitmaps (void)
{
   BRotXP = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)rotXP_bits, rotXP_width, rotXP_height);
   BRotXM = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)rotXM_bits, rotXM_width, rotXM_height);
   BRotYP = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)rotYP_bits, rotYP_width, rotYP_height);
   BRotYM = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)rotYM_bits, rotYM_width, rotYM_height);
   BRotZP = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)rotZP_bits, rotZP_width, rotZP_height);
   BRotZM = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)rotZM_bits, rotZM_width, rotZM_height);
   BMovXP = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)movXP_bits, movXP_width, movXP_height);
   BMovXM = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)movXM_bits, movXM_width, movXM_height);
   BMovYP = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)movYP_bits, movYP_width, movYP_height);
   BMovYM = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)movYM_bits, movYM_width, movYM_height);
   BMovZP = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)movZP_bits, movZP_width, movZP_height);
   BMovZM = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				  (char *)movZM_bits, movZM_width, movZM_height);
   BXaeroIcon = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				      (char *)xaero_bits, xaero_width, xaero_height);
}


void falscheParameter (char **params, char *fehler)
{
   fprintf (stderr,"%s!\n", fehler);
   fprintf (stderr,"parameter for batch-mode:\n");
   fprintf (stderr,"     %s -b -f <name> -s <sequence name> -nb <count>\n", params[0]);
   fprintf (stderr,"     where <name> is filename of a xaero-file,\n");
   fprintf (stderr,"           <sequence name> is the name to save the sequence to,\n");
   fprintf (stderr,"           <count> is the number of steps to go\n");
   exit (-2);
}


void startBatchmode (int count, char **params)
{
   int i, number = -1;
   char *fileName = NULL;
   char *sequenzName = NULL;
   
   /*****************************************************************************
    * In params[0] steht der Name des Programms, kann hier also vernachl"assigt 
    * werden, ebenso der erste Eintrag, in dem -b stehen mu"s.
    *****************************************************************************/
   i = 1;
   while (i < count)
   {
      if (strcmp (params[i],"-f") == 0)
      {
	 i++;
	 fileName = params[i];
	 i++;
      }
      else if (strcmp (params[i],"-s") == 0)
      {
	 i++;
	 sequenzName = params[i];
	 i++;
      }
      else if (strcmp (params[i],"-nb") == 0)
      {
	 i++;
	 number = atoi (params[i]);
	 i++;
      }
      else i++;
/*      else falscheParameter (params,"wrong parameter"); */
   }
   if (fileName != NULL)
      LeseSequenz (fileName, TRUE); /* batchmodus! */
   else falscheParameter (params,"no filename declared");
   if (sequenzName != NULL)
      if (number > 0)
	 berechneSequenz (sequenzName, number);
      else 
      {
	 fprintf (stderr,"no number declared, default is 100\n");
	 berechneSequenz (sequenzName, 100);
      }
   else
   {
      fprintf (stderr,"no sequence name declared, default is aero\n");
      if (number > 0)
	 berechneSequenz("aero", number);
      else 
      {
	 fprintf (stderr,"no number declared, default is 100\n");
	 berechneSequenz("aero", 100);
      }
   }
}


int checkXt (int argc, char **params)
{
   int i = 0, j = 1;

   while (j < argc)
   {
      if (strcmp (params[j],"-f") == 0 || strcmp (params[j],"-s") == 0 ||
          strcmp (params[j],"-nb") == 0 || strcmp (params[j],"-b") == 0)
	 i++;
      j++;
   }
   return (i);
}


/*******************************************************************************
 *  int main (int argc, char **argv)
 *  int  argc   Anzahl der Parameter, die "ubergeben wurden
 *  char **argv Parameterliste
 *
 *  Fehler:
 *
 *  Beschreibung:
 *  -------------
 *  Die Hauptroutine installiert s"amtliche Fenster realisiert den Editor und
 *  geht in eine Schleife ber, die die Events behandelt.
 ********************************************************************************/

void main (int argc, char **argv)
{
   static XtActionsRec EditorAktionen[] = {
             {"quit", Quit}
          };

   initWelt();
   InitFBB (&aktuelleWelt->Welt);

   if (checkXt (argc, argv) > 0)
      startBatchmode (argc, argv);
   else
   {
      topLevel = XtVaAppInitialize (&appContext, "XAero", NULL, 0, &argc,
				    argv, NULL, NULL);
      EM_paneBox = XtVaCreateManagedWidget("EM_paneBox", panedWidgetClass, topLevel, NULL);
      installBitmaps();
      installAnimationWindow();      /* Fenster fr 3-D Animation vorbereiten */
      installMenu();
      installMoreEditorFunctions();
      installEditor();
      installObjektAktionen();
      installSelektAuswahl();
      installVerbindungAufbau();
      installVerbindungsPosition();
      installKamera();
      installAendereVerbindung();
      installBestimmeDateiname();
      installKraftBetrag();
      installAngriffsPunkt();
      installRichtungsVektor();
      installNeuesMaterial();
      installMaterialDaten();
      installGruppiereZusammengestztesObjekt();
      /* Es fehlt noch was */

      fsb_debug_level = 0;
      kb_debug_level = 0;
      s_debug_level = 0;

      XtVaSetValues (topLevel, XtNiconPixmap, BXaeroIcon, NULL);
      
      SetzeActionsAnimation (&appContext, AW_Animation);
      
      XtAppAddActions (appContext, EditorAktionen, XtNumber (EditorAktionen));
      XtRealizeWidget (topLevel);
      InitialisiereDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ, 
			        EM_Darstellung3D);
      SetzeActionsDarstellung (&appContext, EM_DarstellungXY, EM_DarstellungYZ,
			       EM_DarstellungXZ, EM_Darstellung3D);
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			  EM_Darstellung3D, Koordinatenursprung, Ausrichtung, 
			  DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
      InitialisiereAnimation (&appContext, AW_Animation);

      XtAppMainLoop (appContext);
   }
}
