/* Name:            aeropov1.inc
 * Author:          H. Keller
 * Last Change:     3.3.93
 * AERO version:    V1.0 and newer (not recommended anymore since V1.5; use
 *                  POV-Ray V2.x and "aeropov2.inc" to get better results)
 * 
 * Description:
 * This file will be included in all POV-Ray V1.0 scene files which are 
 * automatically created by AERO.
 *
 * Here all basic objects (including links) are defined. They have default 
 * sizes and positions:
 *    box:                    <-0.5 -0.5 -0.5> <0.5 0.5 0.5>
 *    intersection cylinder:  <0.0 0.0 -0.5> <0.0 0.0 0.5> radius 1.0
 *    sphere:                 <0.0 0.0 0.0> radius 1.0
 *    plane:                  <0.0 1.0 0.0> 0.0
 *
 *    intersection rod:       <0.0 0.0 0.0> <0.0 0.0 1.0> radius 0.01
 *    union        damper:    <0.0 0.0 0.0> <0.0 0.0 1.0> radius 0.01 to 0.045
 *    intersection springpart: (spring assembled from small parts) (radius 0.05)
 *    union        joint:     <0.0 0.0 0.0> <0.0 0.0 1.0> radius 0.001
 * 
 * To get a correctly sized and placed object, they are scaled, rotated and
 * translated according to the AERO objects data.
 *
 * Also, the textures of the links are defined in this file.
 *
 */




/***************************
 *  Definition of Objects  *
 ***************************/

#declare aerobox = box  { <-.5 -.5 -.5> <.5 .5 .5> }

#declare aerocylinder =
intersection
{
    quadric 
    { 
	<1.0 1.0 0.0>
	<0.0 0.0 0.0>
	<0.0 0.0 0.0>
	-1.0
    }
    plane { <0.0 0.0 1.0> -0.5 inverse }
    plane { <0.0 0.0 1.0> 0.5 }
}

#declare aerosphere = sphere { <0.0 0.0 0.0> 1.0 }

#declare aeroplane = plane  { <0.0 1.0 0.0> 0.0 }



/**************************
 *  Definitions of Links  *
 **************************/

#declare aerorod =
intersection
{
    quadric 
    { 
	<1.0 1.0 0.0>
	<0.0 0.0 0.0>
	<0.0 0.0 0.0>
	-1.0
    }
    plane { <0.0 0.0 1.0> 0.0 inverse }
    plane { <0.0 0.0 1.0> 1.0 }
    scale <0.01 0.01 1.0>                 /* radius of rod, to define another
					     radius r use "scale <r r 1.0>" */
}

#declare aerodamper =
union
{
    intersection { aerorod }
    intersection 
    {
        quadric
    	{ 
	    <1.0 1.0 0.0>
	    <0.0 0.0 0.0>
	    <0.0 0.0 0.0>
	    -1.0
        }
        plane { <0.0 0.0 1.0> 0.3 inverse }
        plane { <0.0 0.0 1.0> 0.7 }
        scale <0.04 0.04 1.0>
    }
    difference
    {
	intersection
	{
            quadric
    	    { 
	        <1.0 1.0 0.0>
	        <0.0 0.0 0.0>
	        <0.0 0.0 0.0>
	        -1.0
            }
            plane { <0.0 0.0 1.0> 0.5 inverse }
            plane { <0.0 0.0 1.0> 0.7 }
            scale <0.045 0.045 1.0>
	}
	intersection
	{
	    quadric
    	    { 
	        <1.0 1.0 0.0>
	        <0.0 0.0 0.0>
	        <0.0 0.0 0.0>
	        -1.0
            }
            plane { <0.0 0.0 1.0> 0.5 inverse }
            plane { <0.0 0.0 1.0> 0.6 }
            scale <0.043 0.043 1.0>
	}
    }
}


#declare aerojoint =
union
{
    intersection
    {
        quadric
    	{ 
	    <1.0 1.0 0.0>
	    <0.0 0.0 0.0>
	    <0.0 0.0 0.0>
	    -1.0
        }
        plane { <0.0 0.0 1.0> 0.2 inverse }
        plane { <0.0 0.0 1.0> 0.8 }
        scale <0.001 0.001 1.0>     /* radius of rod between joint points; to get
                                       get another radius r use "scale <r r 1.0>" */
    }
/*    sphere { <0.0 0.0 0.0> 0.2 } */
/*    sphere { <0.0 0.0 1.0> 0.2 } */
}

#declare aerospringpart =
intersection
{
    quadric
    {
	<1.0 0.0 1.0>
	<0.0 0.0 0.0>
	<0.0 0.0 0.0>
	-1.0
    }
    plane { <0.0 1.0 0.0> -0.5 inverse }
    plane { <0.0 1.0 0.0> 0.5 }
    scale <0.01 1.0 0.01> 
}

#declare aerospringbound =
intersection
{
    quadric 
    { 
	<1.0 1.0 0.0>
	<0.0 0.0 0.0>
	<0.0 0.0 0.0>
	-1.0
    }
    plane { <0.0 0.0 1.0> 0.0 inverse }
    plane { <0.0 0.0 1.0> 1.0 }
}



/**********************************
 *  Definitions of Link Textures  *
 **********************************/

#declare aerorodtexture =                        /* Texture for Rod */
texture
{
    ambient .15
    color red 0.3 green 0.476555 blue 0.39
    metallic
    brilliance 5.0
    phong .3
}

#declare aerodampertexture =                     /* Texture for Damper */
texture
{
    ambient .15
    color red 0.531243 green 0.3 blue 0.3
    metallic
    brilliance 5.0
    phong .3
}

#declare aerospringtexture =                     /* Texture for Spring */
texture
{
    ambient .15
    color red 0.476555 green 0.476555 blue 0.3
    metallic
    brilliance 5.0
    roughness 0.001
    specular 1.0
}

#declare aerojointtexture =                      /* Texture for Joint */
texture
{
    ambient .15
    color red 0.33 green 0.33 blue 0.37
    metallic
    phong .3
}
