.\" Man page for modeinfo 
.\" First do:
.\"    sed 's/<PROG-NAME>/progname/' modeinfo.man >modeinfo.1
.\" to replace <PROG-NAME> with the actual program name. Then use:
.\" to get a man page, process with
.\"    groff -man -Tascii modeinfo.1 
.\" to get a postscript file, process with
.\"    groff -man -Tps modeinfo.1 >modeinfo.ps
.TH <PROG-NAME> 1 "JULY 1995" Linux "User Manuals"
.SH NAME
<PROG-NAME> \- show information about the video modes available on your computer
.SH SYNOPSIS
.B <PROG-NAME> -a, --all | -v, --available | 
.I modename
.SH DESCRIPTION
.I <PROG-NAME>\^
is a program for showing which video modes are available on your computer, and
gives information about those video modes.
.PP
.I <PROG-NAME> 
uses 
.I svgalib 
functions to determine what video modes are available with your hardware
configuration, and displays some information about the video mode you
specify on the command-line.  Video modes are specified by their symbolic
names, i.e.
.nf

		<PROG-NAME> 640x480x256
or
		<PROG-NAME> G640x480x256
		
.fi
Use the 
.B \-\-available
option to see the names of all the available video modes that can be
entered.  The information from this program can be useful if you want to
know if your computer supports a particular mode, or if you want to know
for example, whether a mode has bitblit available.
.SH OPTIONS
.TP
.BR \-v , " \-\-available"
Display the symbolic names of all of the video modes available with your 
hardware configuration.  These are the names you can enter for the 
.B modename
argument to the program.
.TP
.BR \-a , " \-\-all"
Display mode information for all video modes available with your hardware
configuration.  Better pipe it to a pager or redirect it to a file, because 
it's a lot of information.
.TP
.BR modename
The name of a video mode as shown with the 
.B \-v
option.  
.I <PROG-NAME> 
will display information about this mode.  The
.I G
at the beginning of the name is optional.  Thus
.B G640x480x256
and
.B 640x480x256
are equivalent.
.SH LIMITATIONS
This program just uses
.I svgalib
functions to get its information, so it is only as accurate as svgalib is.
.SH AUTHOR
Adam P. Jenkins <apj@twain.oit.umass.edu>
.SH SEE ALSO
.I svgalib
documents, probably under /usr/src/svgalib.
