
/* qddb/Utils/qindex.c
 * Build the qddb Index file from the Relation.  The Database.keys file
 * must be built prior to building the Index file.
 *
 * Copyright (C) 1993, 1994, 1995 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void main(argc, argv)
    int		argc;
    char	*argv[];
{
    Schema	*ts;
    int		hash_fd;
    char	*RelationPath, HashFN[MAXPATHLEN];	
    
    if (argc != 2) {
	fprintf(stderr, "Usage: %s Relation\n", argv[0]);
	exit(1);
    }
    qddb_stabilizing = 1;
    Qddb_Init();
    RelationPath = Qddb_FindRelation(argv[1]);
    ts = Qddb_InitSchema(RelationPath);
    if (ts == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    strcpy(HashFN, RelationPath);
    strcat(HashFN, "/HashTable");
    hash_fd = Open(HashFN, O_RDWR, 0);
    if (hash_fd == -1) {
	fprintf(stderr, "Cannot open %s for writing\n", HashFN);
	exit(1);
    }
    Close(ts->hashtable_fd);
    ts->hashtable_fd = hash_fd;
    Qddb_MakeIndex(ts);
#if defined(DEBUG_MALLOC)
    malloc_shutdown();
#endif
    exit(0);
}
