
proc gp_new_tuple {rows box} {
    global gv_tuple gv_view gv_attr_pairs gv_attr gv_config
    global gv_mode_variable gv_status_variable gv_tuple_changed gv_entryname
    global gv_delete_button gv_search_button gv_addmode_button gv_clear_button gv_searchmode_button
    global gv_save_button gv_undo_button gv_searchbox_name gv_searchbox_label

    $gv_searchbox_name configure -state disabled
    $gv_searchbox_label configure -state disabled
    if {[winfo exists $box]} {
	set gv_tuple [lindex $rows [$box curselection]]
    } else {
	set gv_tuple [lindex $rows 0]
    }
    set row [lindex $gv_tuple 1]
    set gv_tuple [lindex $gv_tuple 0]
    qddb_view delete all
    set res [catch "qddb_tuple lock $gv_tuple" errmsg]
    if {$res != 0} {
	global gv_lastsearch gv_results_button
	set gv_tuple_changed 0
	gp_search_mode
	set gv_lastsearch {}
	set gv_status_variable $errmsg
	$gv_results_button configure -state disabled
	update idletasks
	return
    }
    if {[string compare $gv_mode_variable "Search Mode"] == 0} {
	foreach i [array names gv_entryname] {
	    switch -exact [winfo class $gv_entryname($i)] {
		Entry {$gv_entryname($i) configure -textvariable gv_attr($i)}
		Text {gp_texttrace_modify $gv_entryname($i) $i}
	    }
	}
    }
    set gv_view [qddb_view define $gv_tuple $gv_attr_pairs]
    qddb_view set $gv_view $row
    gp_bindmod
    if {$errmsg == 1} {
	set gv_mode_variable "Change Mode"
	set gv_status_variable "Ready to modify tuple"
	set gv_tuple_changed 0
	$gv_save_button configure -state normal
	$gv_delete_button configure -state normal
    } elseif {$errmsg == 0} {
	set gv_mode_variable "Read-only Mode"
	set gv_status_variable "Tuple is locked, modifications not allowed"
	set gv_tuple_changed 0
	$gv_save_button configure -state disabled
	$gv_delete_button configure -state disabled
    }
    $gv_search_button configure -state disabled
    $gv_addmode_button configure -state normal
    $gv_clear_button configure -state disabled
    $gv_searchmode_button configure -state normal
    $gv_undo_button configure -state normal
    gp_template_state read disabled
    gp_template_state last disabled
    gp_template_state write normal
    update idletasks
}

proc gp_deletetuple {} {
    global gv_tuple gv_mode_variable gv_status_variable gv_delete_button
    global gv_lastsearch gv_results_button gv_tuple_changed

    if {[string compare [$gv_delete_button configure -state] "disabled"] == 0} {
	return
    }
    if {[tk_dialog .dialog "TUPLE DELETION" \
	     "You have elected to delete the current tuple. This action is irreversible. \
Do you *really* want to do that?" \
	     warning 0 Cancel Yes] == 0} {
	set gv_status_variable "Tuple deletion cancelled."
	update idletasks
	return
    }
    catch [list qddb_tuple remove $gv_tuple]
    set gv_tuple_changed 0
    if {[string compare $gv_mode_variable "Change Mode"] == 0} {
	gp_search_mode
    } else {
	gp_add_mode 1
    }
    set gv_tuple_changed 0
    set gv_lastsearch {}
    $gv_results_button configure -state disabled
}

proc gp_undochanges {} {
    global gv_tuple gv_tuple_changed gv_save_button gv_delete_button
    global gv_mode_variable gv_status_variable

    set res [catch "qddb_tuple lock $gv_tuple" errmsg]
    if {$res == 0 && $errmsg == 1} {
	set gv_mode_variable "Change Mode"
	set gv_status_variable "Ready to modify tuple"
	set gv_tuple_changed 0
	$gv_save_button configure -state normal
	$gv_delete_button configure -state normal
    } elseif {$res == 0 && $errmsg == 0} {
	qddb_tuple refresh $gv_tuple
	set gv_mode_variable "Read-only Mode"
	set gv_status_variable "Tuple is locked, modifications not allowed"
	set gv_tuple_changed 0
	$gv_save_button configure -state disabled
	$gv_delete_button configure -state disabled
    } elseif {$res != 0} {
	global gv_lastsearch gv_results_button
	set gv_tuple_changed 0
	gp_search_mode
	set gv_lastsearch {}
	set gv_status_variable "$errmsg"
	$gv_results_button configure -state disabled
    }
    set gv_tuple_changed 0
}

proc gp_save_current {} {
    global gv_tuple gv_status_variable gv_mode_variable gv_tuple_changed
    global gv_lastadded gv_numadded

    if {[string compare $gv_mode_variable "Search Mode"] == 0 || \
	    [string compare $gv_mode_variable "Read-only Mode"] == 0} {
        return 0
    }
    if {[qddb_tuple isempty $gv_tuple]} {
	set gv_status_variable "Tuple empty, save cancelled."
	return 0
    }
    if {[catch "qddb_tuple write $gv_tuple" error] != 0} {
       set res [tk_dialog .dialog "Tuple write error" \
            "The current tuple cannot be saved for the following reason: $error" \
            info 0 OK]
       set gv_status_variable "An error occurred while writing tuple"
       return 1
    }
    set gv_status_variable "Tuple saved"
    set gv_tuple_changed 0
    update idletasks
    if {[string compare $gv_mode_variable "Add Mode"] == 0} {
	if {![info exists gv_numadded]} {
	    set gv_numadded 0
	}
        set gv_mode_variable "Search Mode"
	set gv_lastadded [qddb_tuple get external $gv_tuple]
	qddb_tuple delete $gv_tuple
        gp_add_mode 1
	incr gv_numadded
	set gv_status_variable "Tuple saved ($gv_numadded this session): Ready to add new tuple"
	update idletasks
    }
    if {[qddb_tuple lock $gv_tuple] == 0} {
	global gv_save_button gv_delete_button

	set gv_mode_variable "Read-only Mode"
	set gv_status_variable "Tuple is locked, modifications not allowed"
	set gv_tuple_changed 0
	$gv_save_button configure -state disabled
	$gv_delete_button configure -state disabled
    }
    set gv_tuple_changed 0
    return 0
}

proc gp_check_tuple {} {
    global gv_tuple_changed gv_mode_variable gv_tuple

    if {[string compare $gv_mode_variable "Search Mode"] == 0 || \
	    [string compare $gv_mode_variable "Read-only Mode"] == 0} {
        return 0
    }
    if {[info exists gv_tuple_changed] && $gv_tuple_changed == 1} {
        set res [tk_dialog .dialog "Tuple modified" \
            "The current tuple has been modified, would you like to save it?" info 0 Yes No Cancel]
        if {$res == 0} {
            if {[gp_save_current] != 0} {
                return 1
            }
        } elseif {$res == 2} {
            return 1
        }
    }
    catch "qddb_tuple refresh $gv_tuple"
    return 0
}

proc gp_add_mode {{change_stat 0}} {
    global gv_mode_variable gv_status_variable gv_tuple_changed
    global gv_tuple gv_view gv_schema gv_attr_pairs gv_attr gv_schema
    global gv_entryname gv_lastadded gv_config
    global gv_delete_button gv_search_button gv_addmode_button gv_searchmode_button
    global gv_save_button gv_clear_button gv_undo_button gv_current_template gv_searchbox_name
    global gv_searchbox_label

    if {[string compare $gv_mode_variable "Change Mode"] == 0} {
        if {[gp_check_tuple] != 0} {
            return
        }
    } elseif {[string compare $gv_mode_variable "Add Mode"] == 0} {
	return
    }
    catch "qddb_tuple unlock $gv_tuple"
    $gv_searchbox_name configure -state disabled
    $gv_searchbox_label configure -state disabled
    $gv_delete_button configure -state disabled
    $gv_search_button configure -state disabled
    $gv_addmode_button configure -state disabled
    $gv_searchmode_button configure -state normal
    $gv_save_button configure -state normal
    $gv_clear_button configure -state normal
    $gv_undo_button configure -state disabled
    gp_template_state read normal
    if {[llength $gv_current_template] > 0} {
	gp_template_state last normal
    }
    gp_template_state write normal
    gp_bindmod
    set leaves [qddb_schema leaves $gv_schema]
    if {[string compare $gv_mode_variable "Search Mode"] == 0} {
	foreach i [array names gv_entryname] {
	    switch -exact [winfo class $gv_entryname($i)] {
		Entry {$gv_entryname($i) configure -textvariable gv_attr($i)}
		Text {gp_texttrace_modify $gv_entryname($i) $i}
	    }
	}
    }
    set gv_mode_variable "Add Mode"
    if {$change_stat == 0} {
	set gv_status_variable "Ready to add new tuple"
    }
    if {![info exists gv_lastadded]} {
	set gv_lastadded ""
    }
    if {$gv_config(conf,auto_clear) == 0 && [string compare $gv_lastadded ""] != 0} {
	set gv_tuple [qddb_tuple put external $gv_schema $gv_lastadded]
    } else {
	set gv_tuple [qddb_tuple new $gv_schema]
    }
    set gv_view [qddb_view define $gv_tuple $gv_attr_pairs]
    focus $gv_entryname([lindex $leaves 0])
    update idletasks
    set gv_tuple_changed 0
}

proc gp_set_tuple_changed {name1 name2 op} {
    global gv_tuple_changed

    set gv_tuple_changed 1
}
