
itcl_class Fx_ExpertSearch {
    global fx_config fx_debug

    constructor {config} {
	global fx_config
	if {[winfo exists $w]} {
	    wm deiconify $w
	    return
	}
	if {![info exists schema] || ![info exists title] || ![info exists w]} {
	    return
	}
	toplevel $w
	wm title $w $title
	wm geometry $w $fx_config(\$$w\$,geometry)
	wm maxsize $w [winfo screenwidth .] [winfo screenheight .]

	frame .but
	pack .but -side bottom -fill x
	button .but.search -text Search -padx 15m -pady 2m
	pack .but.search -side left -padx 20m -pady 4m
	button .but.cancel -text Cancel -padx 15m -pady 2m
	pack .but.cancel -side left -padx 20m -pady 4m
	button .but.write -text Search -padx 15m -pady 2m
	pack .but.write -side right -padx 20m -pady 4m
	button .but.read -text "Read from file" -padx 15m -pady 2m
	pack .but.read -side right -padx 20m -pady 4m
	buildSearchFrame $w.f1 1
	for {set i 2} {$i < 5} {incr i} {
	    buildOperationFrmae $w.o$i $i
	    buildSearchFrame $w.f$i $i
	}
    }
    destructor {
	global fx_config
	set fx_config(\$$w\$,geometry) [wm geometry $w]
	destroy $w
    }
    method buildLine {f n1 n2} {
	global fx_tmpexpert
	radiobutton $f.r_and
	radiobutton $f.r_or
	radiobutton $f.r_not
	menubutton $f.type -textvariable fx_tmpexpert($w,type,$n1,$n2)
	pack $f.type
	menu $f.type.menu
	foreach i {word numeric date regexp} {
	    $f.type.menu add command [list set fx_tmpexpert($w,type,$n1,$n2) $i]
	}
	$f.type.menu add separator
	foreach i {word_range numeric_range date_range} {
	    $f.type.menu add command [list set fx_tmpexpert($w,type,$n1,$n2) $i]
	}
    }
    method buildSearchFrame {f num} {
	frame $f -relief sunken -bd 2
	pack $f -side top -expand on -fill x
	button $f.attr -text Any
	pack $f.attr -side top -expand on -fill x
	frame $f.f_l1
	pack $f.f_l1 -side top
	buildLine $f.f_l1 $num 1
	frame $f.f_l2
	pack $f.f_l2 -side top
	buildLine $f.f_l2 $num 2
	frame $f.f_l3
	pack $f.f_l3 -side top
	buildLine $f.f_l3 $num 3
	frame $f.f_l4
	pack $f.f_l4 -side top
	buildLine $f.f_l4 $num 4
    }
    method buildOperationFrame {f num} {
    }
    public w
    public title
    public schema
    protected current_group
    protected current_field
    
}

