
/* TclQddb_Util.c - Misc utility routines.
 *
 * Copyright (C) 1995 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */


#include "tcl.h"
#include "Qddb.h"
#include "tclQddb.h"

/* qddb_util --
 *	qddb_util isdate <value>
 */

int TclQddb_UtilProc(clientData, interp, argc, argv)
    ClientData			clientData;
    Tcl_Interp			*interp;
    int				argc;
    char			*argv[];
{
    if (argc != 3) {
	Tcl_AppendResult(interp, argv[0], ": wrong # args", NULL);
	return TCL_ERROR;
    }
    if (strcmp(argv[1], "isdate") == 0) {
	if (Qddb_CheckDate(argv[2]) != 0) {
	    Tcl_SetResult(interp, "0", TCL_STATIC);
	    return TCL_OK;
	} else {
	    Tcl_SetResult(interp, "1", TCL_STATIC);
	    return TCL_OK;
	}
    }
    Tcl_AppendResult(interp, argv[0], ": bad command \"", argv[1], "\": should be ",
		     "isdate", NULL);
    return TCL_ERROR;
}
