'\"
'\" qddb/ManPages/mann/Fx_QddbSearchParsser.n
'\" 
'\" Copyright (C) 1995 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH Fx_QddbSearchParser 1 "2 April 1995" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 April 1995
.SH NAME
Fx_QddbSearchParser \- Parse a (possibly nested) list of search keys interspersed with operators.
.SH SYNOPSIS
.ft B
.nf
Fx_QddbSearchParser :: <proc>

.SH PROCEDURES
\fIMultiSearch <schema desc> <list> ?<exact>? ?<pruneby>?\fR
Accepts (1) a schema descriptor, (2) a list of keys in the same form accepted by
\fBnxqddb(1)\fR, (3) \fIon\fR if the operations should be performed such that all matches
must be in the same instance of the attribute, otherwise \fIoff\fR 
(i.e. strong operations are \fIon\fR, weak operatons are \fIoff\fR), (4) an attribute to prune by, if any.
.nf
    set k [Fx_QddbSearchParser :: MultiSearch $schema \
        {joe , {henry john}} on Name.First]
.fi
Returns a keylist descriptor for the result.

.SH SEE ALSO
Fx_Frame(n), Fx_Menubar(n), Fx_Entry(n), Fx:Print(n), Fx(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
.SH COPYRIGHT
.nf
Copyright (C) 1993, 1994 Herrin Software Development, Inc.
All rights reserved.
.fi
.PP
This manual page is part of Qddb.
.PP
Qddb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License Version 2
as published by the Free Software Foundation.
.PP
Qddb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with Qddb; see the file LICENSE.  If not, write to:
.sp
.nf
        Herrin Software Development, Inc. 
        R&D Division
        41 South Highland Ave. 
        Prestonsburg, KY 41653 
.fi
