%{

/* qddb/Lib/LibQsql/SqlParse.y -- just a stub right now.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

/* redefine the parser and lexical analyser to be
 * the proper names
 */
#define yyparse	SqlParse
#define yylex	Qsqllex

int yylex();
int yywrap();

/* Global stack for parser to get rid of malloc and free overhead. 
 */
Constant	Constants[CONSTANTSIZE];
unsigned int	ConstantsTop = 0;

Identifier	Identifiers[IDENTIFIERSIZE];
unsigned int	IdentifiersTop = 0;

ClistNode	Clists[CLISTSSIZE];
unsigned int	ClistsTop = 0;

OpStack		Ops[OPSSIZE];
unsigned int 	OpsTop = 0;

OpStackList	OpStackLists[OPSTACKLISTSIZE];
unsigned int	OpStackListsTop = 0;

TabExp		TabExps[TABEXPSIZE];
unsigned int	TabExpsTop = 0;
%}

%pure_parser
%expect 8

%token SELECT DISTINCT FROM WHERE 
%token IDENTIFIER
%token DOT COMMA 
%token LPAREN RPAREN
%token STRING REAL INTEGER
%token OR AND
%token IN
%token CREATE TABLE
%token INSERT INTO VALUES
%token DELETE UPDATE 
%token EXISTS NOT
%token ASTERISK
%token VIEW
%token NULLVALUE UNIQUE
%token SCHEMA GRANT ON TO PUBLIC WITH CHECK OPTION
%token CLOSE COMMIT WORK FETCH CURRENT OF OPEN SET
%token ROLLBACK
%token UNION GROUP BY HAVING 
%token BETWEEN IS LIKE AS
%token DIV PLUS MINUS
%token INDICATOR AUTHORIZATION
%token PRIVILEGES ESCAPE
%token STRINGTYPE INTEGERTYPE REALTYPE UNSIGNEDTYPE
%token AVGFUNC MAXFUNC MINFUNC SUMFUNC COUNTFUNC
%token EQ NE GT 
%token GE LE LT
%token ANY ALL SOME

/* non-terminals */
%type <unsign>  IdentifierReference
%type <unsign>	IdentifierReferenceCommaList
%type <unsign>	Table
%type <unsign>  TableReference
%type <unsign>  TableReferenceCommaList

%type <unsign>  Literal
%type <unsign>  Atom
%type <unsign>  AtomCommaList
%type <unsign>	Primary
%type <unsign>  ScalarExpression
%type <unsign>  ScalarExpressionCommaList
%type <unsign>  Factor
%type <unsign>  Term
%type <unsign>  QueryTerm
%type <unsign>  QuerySpecification
%type <unsign>  Selection
%type <unsign>  TableExpression

%type <unsign>  Predicate
%type <unsign>	ComparisonPredicate
%type <unsign>  BooleanFactor
%type <unsign>  BooleanTerm
%type <unsign>  BooleanPrimary
%type <unsign>  FromClause
%type <unsign>  SearchCondition
%type <unsign>  WhereClause

%type <unsign>  Subquery

%type <Operation> Comparison

/* terminals */
%type <string>  IDENTIFIER
%type <string>  STRING
%type <real>	REAL
%type <integer> INTEGER

%left OR
%left AND
%nonassoc EQ NE GT GE LT LE 
%nonassoc ANY ALL SOME
%nonassoc IN

%union {
    char		*string;
    int			integer;
    double		real;
    unsigned int	unsign;
    Operation		Operation;
};

%start SqlStart

%%

SqlStart:
    SqlStatement | 
    SqlStart SqlStatement;

SqlStatement:
    Schema {
    } | 
    ManipulativeStatement {
    } |
    QueryExpression {
    };

Schema:
    CREATE SCHEMA AUTHORIZATION IDENTIFIER {
	/* CREATE SCHEMA AUTHORIZATION User */
    } |
    CREATE SCHEMA AUTHORIZATION IDENTIFIER SchemaElementList {
	/* CREATE SCHEMA AUTHORIZATION User SchemaElementList */
    };

SchemaElementList:
    SchemaElement {
    } |
    SchemaElementList SchemaElement {
    };

SchemaElement:
    BaseTableDefinition {
    } |
    ViewDefinition {
    } |
    PrivilegeDefinition {
    };

BaseTableDefinition:
    CREATE TABLE IdentifierReference LPAREN BaseTableElementCommaList RPAREN {
	/* CREATE TABLE BaseTable LPAREN BaseTableElementCommaList RPAREN */
    };

BaseTableElementCommaList:
    BaseTableElement {
    } |
    BaseTableElementCommaList COMMA BaseTableElement {
    };


BaseTableElement:
    ColumnDefinition {
    } |
    UniqueConstraintDefinition {
    };

ColumnDefinition:
    IDENTIFIER DataType {
    } |
    IDENTIFIER DataType NOT NULLVALUE {
    } |
    IDENTIFIER DataType NOT NULLVALUE UNIQUE {
    };

DataType:
    STRINGTYPE {
    } | 
    INTEGERTYPE {
    } |
    REALTYPE {
    } |
    UNSIGNEDTYPE {
    };

UniqueConstraintDefinition:
    UNIQUE LPAREN IdentifierReferenceCommaList RPAREN {
	/* UNIQUE LPAREN ColumnCommaList RPAREN */
    };

ViewDefinition:
    CREATE VIEW IdentifierReference AS QuerySpecification {
    } |
    CREATE VIEW IdentifierReference LPAREN IdentifierReferenceCommaList
    RPAREN AS QuerySpecification {
    } |
    CREATE VIEW IdentifierReference AS QuerySpecification WITH CHECK OPTION {
    } |
    CREATE VIEW IdentifierReference LPAREN IdentifierReferenceCommaList
    RPAREN AS QuerySpecification WITH CHECK OPTION {
    };


PrivilegeDefinition:
    GRANT Privileges ON Table TO GranteeCommaList {
    } |
    GRANT Privileges ON Table TO GranteeCommaList WITH GRANT OPTION {
    };

Privileges:
    ALL {
    } |
    ALL PRIVILEGES {
    } |
    OperationCommaList {
    };

OperationCommaList:
    Operation {
    } |
    OperationCommaList COMMA Operation {
    };

Operation:
    SELECT {
    } |
    INSERT {
    } |
    DELETE {
    } |
    UPDATE {
    } |
    LPAREN IdentifierReferenceCommaList RPAREN {
	/* LPAREN ColumnCommaList RPAREN */
    };

GranteeCommaList:
    PUBLIC {
    } |
    IDENTIFIER {
    };

ManipulativeStatement:
    CloseStatement {
    } |
    CommitStatement {
    } |
    DeleteStatementPositioned {
    } |
    DeleteStatementSearched {
    } |
    FetchStatement {
    } |
    InsertStatement {
    } |
    OpenStatement {
    } |
    RollBackStatement {
    } |
    SelectStatement {
    } |
    UpdateStatementPositioned {
    } |
    UpdateStatementSearched {
    };

CloseStatement:
    CLOSE IDENTIFIER {
    };

CommitStatement:
    COMMIT WORK {
    };

DeleteStatementPositioned:
    DELETE FROM Table WHERE CURRENT OF IDENTIFIER {
	/* OF Cursor */
    };

DeleteStatementSearched:
    DELETE FROM Table {
    } |
    DELETE FROM Table WhereClause {
    };

FetchStatement:
    FETCH IDENTIFIER INTO TargetCommaList {
	/* FETCH Cursor */
    };

InsertStatement:
    INSERT INTO Table VALUES LPAREN InsertAtomCommaList RPAREN {
    } |
    INSERT INTO Table QuerySpecification {
    } |
    INSERT INTO Table LPAREN IdentifierReferenceCommaList RPAREN 
    VALUES LPAREN InsertAtomCommaList RPAREN {
    } |
    INSERT INTO Table LPAREN IdentifierReferenceCommaList RPAREN 
    QuerySpecification {
    };

InsertAtomCommaList:
    InsertAtom {
    } |
    InsertAtomCommaList COMMA InsertAtom {
    };

InsertAtom:
    Atom {
    } |
    NULLVALUE {
    };

OpenStatement:
    OPEN IDENTIFIER {
	/* OPEN Cursor */
    };

RollBackStatement:
    ROLLBACK WORK {
    };

SelectStatement:
    SELECT Selection INTO TargetCommaList TableExpression {
    } |
    SELECT ALL Selection INTO TargetCommaList TableExpression {
    } |
    SELECT DISTINCT Selection INTO TargetCommaList TableExpression {
    };

TargetCommaList:
    Target {
    } |
    TargetCommaList Target {
    };

Target:
    ParameterReference {
    };

ParameterReference:
    IdentifierReference {
    } |
    IdentifierReference IdentifierReference {
    } |
    IdentifierReference INDICATOR IdentifierReference {
    };

UpdateStatementPositioned:
    UPDATE Table SET AssignmentCommaList WHERE CURRENT OF IDENTIFIER {
    };

UpdateStatementSearched:
    UPDATE Table SET AssignmentCommaList {
    } |
    UPDATE Table SET AssignmentCommaList WhereClause {
    };

AssignmentCommaList:
    Assignment {
    } |
    AssignmentCommaList COMMA Assignment {
    };

Assignment:
    /* IDENTIFIER == Column */
    IDENTIFIER EQ ScalarExpression {
    } |
    IDENTIFIER EQ NULLVALUE {
    };

/* BEGIN QUERY */
QueryExpression:
    QueryTerm {
    } |
    QueryExpression UNION QueryTerm {
    } |
    QueryExpression UNION ALL QueryTerm {
    };

QueryTerm:
    QuerySpecification {
    } |
    LPAREN QueryExpression RPAREN {
    };

QuerySpecification:
    SELECT Selection TableExpression {
    } |
    SELECT ALL Selection TableExpression {
    } |
    SELECT DISTINCT Selection TableExpression {
    };

Selection:
    ScalarExpressionCommaList {
    } |
    ASTERISK {
    };

TableExpression:
    FromClause {
    } |
    FromClause WhereClause {
    } |
    FromClause GroupByClause {
    } |
    FromClause WhereClause GroupByClause {
    } |
    FromClause HavingClause {
    } |
    FromClause WhereClause HavingClause {
    } |
    FromClause GroupByClause HavingClause {
    } |
    FromClause WhereClause GroupByClause HavingClause {
    };

FromClause:
    FROM TableReferenceCommaList {
    };

TableReferenceCommaList:
    TableReference {
    } |
    TableReferenceCommaList COMMA TableReference {
    };

TableReference:
    IdentifierReference {
    } |
    IdentifierReference IDENTIFIER {
    };

WhereClause:
    WHERE SearchCondition {
    };

GroupByClause:
    GROUP BY IdentifierReferenceCommaList {
    };

HavingClause:
    HAVING SearchCondition {
    };

SearchCondition:
    BooleanTerm {
    } |
    SearchCondition OR BooleanTerm {
    };

BooleanTerm:
    BooleanFactor {
    } |
    BooleanTerm AND BooleanFactor {
    };

BooleanFactor:
    BooleanPrimary {
    } |
    NOT BooleanPrimary {
    };

BooleanPrimary:
    Predicate {
    } |
    LPAREN SearchCondition RPAREN {
    };

Predicate:
    ComparisonPredicate {
    } |
    BetweenPredicate {
    } |
    LikePredicate {
    } |
    TestForNull {
    } |
    InPredicate {
    } | 
    AllOrAnyPredicate {
    } |
    ExistenceTest {
    };

ComparisonPredicate:
    ScalarExpression Comparison ScalarExpression {
    } |
    ScalarExpression Comparison Subquery {
    };

Comparison:
    EQ {
    } |
    NE {
    } |
    LT {
    } |
    GT {
    } |
    LE {
    } |
    GE {
    };

BetweenPredicate:
    ScalarExpression BETWEEN ScalarExpression AND ScalarExpression {
    } |
    ScalarExpression NOT BETWEEN ScalarExpression AND ScalarExpression {
    };

LikePredicate:
    IdentifierReference LIKE Atom {
    } |
    IdentifierReference NOT LIKE Atom {
    } |
    IdentifierReference LIKE Atom ESCAPE Atom {
    } |
    IdentifierReference NOT LIKE Atom ESCAPE Atom {
    } |
    IdentifierReference LIKE IdentifierReference {
    } |
    IdentifierReference NOT LIKE IdentifierReference {
    } |
    IdentifierReference LIKE IdentifierReference ESCAPE IdentifierReference {
    } |
    IdentifierReference NOT LIKE IdentifierReference ESCAPE IdentifierReference {
    };

TestForNull:
    IdentifierReference IS NULLVALUE {
    } |
    IdentifierReference IS NOT NULLVALUE {
    };

InPredicate:
    ScalarExpression IN Subquery {
    } |
    ScalarExpression NOT IN Subquery {
    } |
    ScalarExpression IN AtomCommaList {
    } |
    ScalarExpression NOT IN AtomCommaList {
    } |
    ScalarExpression IN IdentifierReferenceCommaList {
    } |
    ScalarExpression NOT IN IdentifierReferenceCommaList {
    };

AllOrAnyPredicate:
    ScalarExpression Comparison ALL Subquery {
    } |
    ScalarExpression Comparison ANY Subquery {
    } |
    ScalarExpression Comparison SOME Subquery {
    };

ExistenceTest:
    EXISTS Subquery {
    };

Subquery:
    LPAREN SELECT Selection TableExpression RPAREN {
    } |
    LPAREN SELECT ALL Selection TableExpression RPAREN {
    } |
    LPAREN SELECT DISTINCT Selection TableExpression RPAREN {
    };

ScalarExpression:
    Term {
    } |
    ScalarExpression PLUS Term {
    } |
    ScalarExpression MINUS Term {
    };

ScalarExpressionCommaList:
    ScalarExpression {
    } |
    ScalarExpressionCommaList ScalarExpression {
    };

Term:
    Factor {
    } |
    Term ASTERISK Factor {
    } |
    Term DIV Factor {
    };

Factor:
    Primary {
    } |
    PLUS Primary {
    } |
    MINUS Primary {
    };

Primary:
    /* Returns an index into OpStackList */
    Atom {
    } |
    IdentifierReference {
    } |
    FunctionReference {
    } |
    LPAREN ScalarExpression RPAREN {
    };

AtomCommaList:
    Atom {
    } |
    AtomCommaList COMMA Atom {
    };

Atom:
    Literal {
    };

FunctionReference:
    COUNTFUNC LPAREN ASTERISK RPAREN {
    } |
    DistinctFunctionReference {
    } |
    AllFunctionReference {
    };

DistinctFunctionReference:
    AVGFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    } |
    MAXFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    } |
    MINFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    } |
    SUMFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    } |
    COUNTFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    };

AllFunctionReference:
    AVGFUNC LPAREN ALL ScalarExpression RPAREN {
    } |
    MAXFUNC LPAREN ALL ScalarExpression RPAREN {
    } |
    MINFUNC LPAREN ALL ScalarExpression RPAREN {
    } |
    SUMFUNC LPAREN ALL ScalarExpression RPAREN {
    } |
    COUNTFUNC LPAREN ALL ScalarExpression RPAREN {
    };

Table:
    IdentifierReference {
    };

IdentifierReference:
    IDENTIFIER {
    };

IdentifierReferenceCommaList:
    IdentifierReference {
    } |
    IdentifierReferenceCommaList COMMA IdentifierReference {
    };

Literal:
    STRING {
    } |
    INTEGER {
    } |
    REAL {
    };

%%
static	char		Strings[STRINGSIZE];
static  unsigned int	StringsTop = 0;

char *AllocString(HowManyBytes)
    unsigned int	HowManyBytes;
{
    char		*str;

    if ((StringsTop + HowManyBytes) >= STRINGSIZE)
	PANIC("Constant STRINGSIZE too small: increase in Headers/Sql.h\n");
    str = Strings + StringsTop;
    StringsTop += HowManyBytes + 1;
    return str;
}

#ifdef SQLDEBUG
DEBUGprintFromWhere(index)
    unsigned int		index;
{
    unsigned int		i, top, bot;

    i = TabExps[index].From;
    printf("FROM:\n");
    while (i != NIL) {
	printf("Table %s\n", Identifiers[Clists[i].Index].TableName);
	i = Clists[i].Next;
    }
    printf("WHERE:\n");
    i = TabExps[index].Where;
    top = OpStackLists[i].Top;
    bot = OpStackLists[i].Bottom;
    for (i = bot; i <= top; i++) {
	printf("(%u)", i);
	switch (Ops[i].Op) {
	case NONE:
	    switch (Ops[i].Val.Type) {
	    case OPCONSTANT:
		switch (Constants[Ops[i].Val.Index].Type) {
		case STRINGCONS:
		    printf("[cons] %s ", Constants[Ops[i].Val.Index].Val.String);
		    break;
		case INTEGERCONS:
		    printf("[cons] %d ", Constants[Ops[i].Val.Index].Val.Integer);
		    break;
		case REALCONS:
		    printf("[cons] %lf ", Constants[Ops[i].Val.Index].Val.Real);
		    break;
		default:
		    printf("Invalid Constant type \n");
		    break;
		}
		break;
	    case OPIDENT:
		printf("[ident] %s:%s", Identifiers[Ops[i].Val.Index].TableName,
		       Identifiers[Ops[i].Val.Index].ColumnName);
		break;
	    case OPSTACK:
		printf("Ops[i].Val.Type == OPSTACK!\n");
	    default:
		printf("Invalid primary type\n");
		break;
	    }
	    break;
	case LESSTHAN:
	    printf("<");
	    break;
	case LESSEQUAL:
	    printf("<=");
	    break;
	case GREATERTHAN:
	    printf(">");
	    break;
	case GREATEREQUAL:
	    printf(">=");
	    break;
	case EQUAL:
	    printf("=");
	    break;
	case NOTEQUAL:
	    printf("!=");	
	    break;
	case SUBTRACT:
	    printf("-");
	    break;
	case ADD:
	    printf("+");
	    break;
	case MULTIPLY:
	    printf("*");
	    break;
	case DIVIDE:
	    printf("/");
	    break;
	case INTERSECTIONOP:
	    printf("INTERSECT:");
	    break;
	case UNIONOP:
	    printf("UNION:");
	    break;
	default:
	    printf("Operation type invalid\n");
	}
    }
    printf("\n");
}
#endif
