
/* qddb/Lib/LibQddb/Changes.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

/* EXPORTED:
 *	void Qddb_ChangeEntry
 *	void Qddb_AddEntry
 */

static int FindNextNumber _ANSI_ARGS_((char *));

void Qddb_ChangeEntry(schema, File, Locked, ThisEntry, Type)
    Schema		*schema;
    int			File;
    Boolean		Locked;
    Entry		ThisEntry;
    KeyListType		Type;
{
    char		*RelationFN = schema->RelationName;
    char		Path[MAXFILENAMELEN], tmpbuf[BUFSIZ];
    int			EntryNumber;

    strcpy(Path, RelationFN);
    if (Type != ADDITION)
	strcat(Path, "/Changes/");
    else
	strcat(Path, "/Additions/");
    sscanf(ThisEntry[0], "%*s %*c %d", &EntryNumber);
    sprintf(tmpbuf, "%s%d", Path, EntryNumber);
    if (File == -1 && (File = Open(tmpbuf, O_RDWR|O_CREAT|O_TRUNC, 0666)) == -1) {
	PANIC("Cannot open changes file");
    } else {
	lseek(File, (off_t)0, 0);
#if defined(HAVE_FTRUNCATE)
	ftruncate(File, (off_t)0);
#else
	/* we lose the lock here */
	close(Open(tmpbuf, O_RDWR|O_CREAT|O_TRUNC, 0644));
#endif
    }
#if defined(RECORDLOCKING)
    if (LockSection(File, F_WRLCK, (off_t)0, (off_t)0, True) == -1)
	perror("warning: failed to obtain lock\n");
#endif
    WriteEntry(schema, File, ThisEntry);
#if defined(RECORDLOCKING)
    if (Locked == False) {
	UnlockSection(File, (off_t)0, (off_t)0);
	Close(File);
    } else {
	if (LockSection(File, F_RDLCK, (off_t)0, (off_t)0, True) == -1)
	    perror("failed to revert to read lock\n");
    }
#else
    Close(File);
#endif
}

int Qddb_AddEntry(schema, NewFile, Lockit, ThisEntry)
    Schema		*schema;
    int			*NewFile;
    Boolean		Lockit;
    Entry		ThisEntry;
{
    char		*RelationFN = schema->RelationName;
    char		Path[MAXFILENAMELEN], *tmpbuf, *tmp;
    int			EntryNumber;
    int			File;
    int			FindNextNumber _ANSI_ARGS_((char *));

    strcpy(Path, RelationFN);
    strcat(Path, "/Additions/");
    EntryNumber = FindNextNumber(Path);
    if (EntryNumber == -1)
	return -1;
    tmpbuf = Malloc(MAXFILENAMELEN);
    sprintf(tmpbuf, "%s%d", Path, EntryNumber);
    if ((File = Open(tmpbuf, O_RDWR|O_CREAT|O_EXCL, 0666)) == -1) {
	char		errbuf[BUFSIZ];

	sprintf(errbuf, "Cannot open Additions file: %d\n", EntryNumber);
	PANIC(errbuf);
    }
#if defined(RECORDLOCKING)
    LockSection(File, F_WRLCK, (off_t)0, (off_t)0, True);
#endif
    sprintf(tmpbuf, "%%0 V %d", EntryNumber);
    tmp = ThisEntry[0];
    ThisEntry[0] = tmpbuf;
    WriteEntry(schema, File, ThisEntry);
    Free(tmp);
#if defined(RECORDLOCKING)
    if (Lockit == False) {
	UnlockSection(File, (off_t)0, (off_t)0);
	Close(File);
    } else {
	LockSection(File, F_RDLCK, (off_t)0, (off_t)0, True);
	if (NewFile != NULL)
	    *NewFile = File;
    }
#else
    Close(File);
#endif
    return EntryNumber;
}

static int FindNextNumber(Path)
    char		*Path;
{
    char		tmpPath[BUFSIZ], buf[BUFSIZ];
    int			NextNumber;
    int			File;

    strcpy(tmpPath, Path);
    strcat(tmpPath, "/NextEntry");
    if ((File = Open(tmpPath, O_RDWR|O_CREAT, 0644)) == -1)
	PANIC("Cannot open Additions/NextEntry file");
#if defined(RECORDLOCKING)
    if (LockSection(File, F_WRLCK, (off_t)0, (off_t)0, True) == -1)
	return -1;
#endif
    read(File, buf, SizeOfFile(File));
    sscanf(buf, "%d", &NextNumber);
    NextNumber++;
    sprintf(buf, "%d\n", NextNumber);
    lseek(File, (off_t)0, 0);
    write(File, buf, strlen(buf));
#if defined(RECORDLOCKING)
    UnlockSection(File, (off_t)0, (off_t)0);
#endif
    close(File);
    return NextNumber;
}

