/*-------------------------------------------------------------------------
 *
 * testlibpq.c--
 *    
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/libpq++/testlibpq.cc,v 1.1 1995/01/10 00:41:12 jolly Exp
 *
 *-------------------------------------------------------------------------
 */

#include <stdio.h>
#include "libpq++.H"

int 
main(int argc, char** argv)
{
  PGenv env;
  PGconn* conn;
  PGresult* res;
  char buf[10000];
  int done = 0;

  conn = new PGconn(&env, "jolly");
  if (conn->status() == CONNECTION_BAD)
    printf("connection was unsuccessful\n%s\n", conn->errMsg());
  else
    printf("connection successful\n");

  while (!done)
    {
      printf("> ");fflush(stdout);
      if (gets(buf) && buf[0]!='\0') {
	res = conn->exec(buf);
	printf("status = %s\nerrorMessage = %s\n", 
	       pgresStatus[res->status()],
	       conn->errMsg());
	if (res->status() == PGRES_TUPLES_OK)
	  {
	    int i,j,k ;
	    for (i=0;i<res->ngroups();i++)
	      {
		printf("Group # %d\n", i);
		PGresGroup group = res->groups[i];
		for (j=0;j<group.numAttributes;j++) {
		  printf("%s\t", group.attDescs[j].name);
		  }
		printf("\n");
		for (j=0;j<group.numTuples;j++) {
		  for (k=0;k<group.numAttributes;k++)
		    if (group.tuples[j][k])
		      printf("%s\t", group.tuples[j][k]);
		    else
		      printf("<NULL>\t", group.tuples[j][k]);
		printf("\n");
		  }
	      }
	  }

      }
      else
	done = 1;
    }
  delete conn;
}
