#include "request.h"

void make_screen( int direction )
{
  int line_pos = 0;
  struct file_pos *help;

  switch(direction)
    {
    case PAGE_UP:
      /* go back one page */
      while ( (line_pos++ <= screen_height) && ((line->prev) != NULL) )
	line = line->prev;
      if( (line->prev) == NULL )
	curr_pos = 0;
      break;
    case PAGE_DN:
      /* scroll down one page */
      while( (line_pos++ <= screen_height) && ((line->next) != NULL) )
	line = line->next;
      if( (line->next) == NULL )
	curr_pos = screen_height;
      break;
    case SCROLL_UP:
      if ( line->prev != NULL )
        line = line->prev;
      else
	curr_pos = 0;
      break;
    case SCROLL_DN:
      if ( line->next != NULL )
	line = line->next;
      else
	curr_pos = screen_height;
      break;

    default:
      /* update only the screen */
      break;
    }

  line_pos = 0;
  help = line;
  while ( (line_pos <= screen_height) ) 
    {
      if (has_colors())
	{
	  init_pair( ++pair, COLOR_WHITE, COLOR_BLUE );
	  attrset( COLOR_PAIR(pair) );
	  if (pair==2)
	    pair=0;
	}
      get_line( line_pos++ );
      if ( line->next != NULL )
	line = line->next;
    }
  line = help;
  /* draw status line */
  if (has_colors())
    {
      init_pair( ++pair, COLOR_WHITE, COLOR_BLUE );
      attrset( COLOR_PAIR(pair) );
      if (pair==2)
	pair=0;
    }
  status_line( "" );
  refresh();
}

