/* Copyright (c) 1991
 *      Juergen Weigert (jnweiger@immd4.informatik.uni-erlangen.de)
 *      Michael Schroeder (mlschroe@immd4.informatik.uni-erlangen.de)
 * Copyright (c) 1987 Oliver Laumann
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Noteworthy contributors to screen's design and implementation:
 *	Wayne Davison (davison@borland.com)
 *	Patrick Wolfe (pat@kai.com, kailand!pat)
 *	Bart Schaefer (schaefer@cse.ogi.edu)
 *	Nathan Glasser (nathan@brokaw.lcs.mit.edu)
 *	Larry W. Virden (lvirden@cas.org)
 *	Howard Chu (hyc@hanauma.jpl.nasa.gov)
 *	Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
 *	Markku Jarvinen (mta@{cc,cs,ee}.tut.fi)
 *	Marc Boucher (marc@CAM.ORG)
 *
 ****************************************************************
 * $Id: window.h,v 1.9 92/11/12 13:25:15 mlschroe Exp $ FAU
 */

#undef MAXWIN20

#ifdef MAXWIN20
#define MAXWIN	20
#else
#define MAXWIN	10
#endif

struct win 
{
  struct win *next;		/* next window */
  struct display *display;	/* pointer to our display */
  int	number;			/* window number */
  int	active;			/* is window fore ? */
  struct layer *wlay;		/* the layer of the window */
  struct layer winlay;		/* the layer of the window */
  int	w_pid;			/* process at the other end of ptyfd */	
  int	w_ptyfd;		/* fd of the master pty */
  int	aflag;			/* (used for DUMP_TERMCAP) */
  char	inbuf[IOSIZE];
  int	inlen;
  char	outbuf[IOSIZE];
  int	outlen;
  int	autoaka, akapos;	/* autoaka hack */
  char	cmd[MAXSTR];
  char	w_tty[MAXSTR];
  struct tty_attr t;
  int	intermediate;		/* char used while parsing ESC-seq */
  int	args[MAXARGS];
  int	NumArgs;
  slot_t slot;			/* utmp slot */
#if defined (UTMPOK)
  struct utmp savut;
#endif
  char	**w_image;
  char	**w_attr;
  char	**w_font;
  int	x, y;			/* Cursor position */
  int	w_width, w_height;	/* window size */
  char	Attr;			/* character attributes */
  int	Charset;		/* charset number */
  int	charsets[4];		/* Font = charsets[Charset] */
  int	ss;		
  int	saved;
  int	Saved_x, Saved_y;
  char	SavedAttr;
  int	SavedCharset;
  int	SavedCharsets[4];
  int	w_top, w_bot;		/* scrollregion */
  int	wrap;			/* autowrap */
  int	origin;			/* origin mode */
  int	w_insert;		/* window is in insert mode */
  int	w_keypad;		/* keypad mode */
  int	w_cursorkeys;		/* appl. cursorkeys mode */
#ifdef COPY_PASTE
  int	histheight;		/* all histbases are malloced with width * histheight */
  int	histidx;		/* 0 <= histidx < histheight; where we insert lines */
  char	**ihist; 		/* the history buffer image */
  char	**ahist; 		/* attributes */
  char	**fhist; 		/* fonts */
#endif
  enum	state_t state;		/* parser state */
  enum	string_t StringType;
  char	string[MAXSTR];
  char	*stringp;
  char	*tabs;			/* line with tabs */
  int	vbwait;            
  int	bell;
  int	w_flow;
  FILE	*logfp;
  int	monitor;
  int	cursor_invisible;
  int	norefresh;		/* dont redisplay when switching to that win */
};

/*
 * Definitions for flow
 *   000  -(-)
 *   001  +(-)
 *   010  -(+)
 *   011  +(+)
 *   100  -(a)
 *   111  +(a)
 */
#define FLOW_NOW	(1<<0)
#define FLOW_AUTO	(1<<1)
#define FLOW_AUTOFLAG	(1<<2)


/*
 * iWIN gives us a reference to line y of the *whole* image
 * where line 0 is the oldest line in our history.
 * y must be in WIN coordinate system, not in display.
 */
#define iWIN(y) ((y < fore->histheight) ? fore->ihist[(fore->histidx + y)\
                % fore->histheight] : fore->w_image[y - fore->histheight])
#define aWIN(y) ((y < fore->histheight) ? fore->ahist[(fore->histidx + y)\
                % fore->histheight] : fore->w_attr[y - fore->histheight])
#define fWIN(y) ((y < fore->histheight) ? fore->fhist[(fore->histidx + y)\
                % fore->histheight] : fore->w_font[y - fore->histheight])


#define W2D(y) ((y) - markdata->hist_offset)
#define D2W(y) ((y) + markdata->hist_offset)

