/* Copyright (c) 1991
 *      Juergen Weigert (jnweiger@immd4.informatik.uni-erlangen.de)
 *      Michael Schroeder (mlschroe@immd4.informatik.uni-erlangen.de)
 * Copyright (c) 1987 Oliver Laumann
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Noteworthy contributors to screen's design and implementation:
 *	Wayne Davison (davison@borland.com)
 *	Patrick Wolfe (pat@kai.com, kailand!pat)
 *	Bart Schaefer (schaefer@cse.ogi.edu)
 *	Nathan Glasser (nathan@brokaw.lcs.mit.edu)
 *	Larry W. Virden (lvirden@cas.org)
 *	Howard Chu (hyc@hanauma.jpl.nasa.gov)
 *	Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
 *	Markku Jarvinen (mta@{cc,cs,ee}.tut.fi)
 *	Marc Boucher (marc@CAM.ORG)
 *
 ****************************************************************
 * $Id: os.h,v 1.4 92/11/19 17:55:48 mlschroe Exp Locker: mlschroe $ FAU
 */


#include <stdio.h>
#include <errno.h>

#ifdef ISC
# ifdef ENAMETOOLONG
#  undef ENAMETOOLONG
# endif
# ifdef ENOTEMPTY
#  undef ENOTEMPTY
# endif
# include <net/errno.h>
#endif

#if defined(pyr)
extern int errno;
#endif

#ifdef sun
# define getpgrp __getpgrp
# define exit __exit
#endif

#ifdef POSIX
# include <unistd.h>
# if defined(__STDC__)
#  include <stdlib.h>
# endif /* __STDC__ */
#endif /* POSIX */

#ifdef sun
# undef getpgrp
# undef exit
#endif /* sun */

#ifdef POSIX
# include <termios.h>
# ifdef hpux
#  include <bsdtty.h>
# endif /* hpux */
#else /* POSIX */
# ifdef TERMIO
#  include <termio.h>
# else /* TERMIO */
#  include <sgtty.h>
# endif /* TERMIO */
#endif /* POSIX */

#if defined(BSD) || defined(sequent) || defined(pyr)
# ifdef NEWS_OS
#  define strlen ___strlen___
#  include <strings.h>
#  undef strlen
# else
#  include <strings.h>
# endif 
#else /* BSD */
# ifdef SVR4
#  define strlen ___strlen___
#  include <string.h>
#  undef strlen
   extern size_t strlen(const char *);
# else /* SVR4 */
#  include <string.h>
# endif /* SVR4 */
#endif /* BSD */

#if (defined(TIOCGWINSZ) || defined(TIOCSWINSZ)) && defined(M_UNIX)
# include <sys/stream.h>
# include <sys/ptem.h>
#endif

#ifdef UTMPOK
# ifdef SVR4
#  include <utmpx.h>
#  define UTMPFILE	UTMPX_FILE
#  define utmp		utmpx
#  define getutent	getutxent
#  define getutid	getutxid
#  define getutline	getutxline
#  define pututline	pututxline
#  define setutent	setutxent
#  define endutent	endutxent
# else /* SVR4 */
#  include <utmp.h>
# endif /* SVR4 */
# if defined(apollo) || defined(linux)
   /* 
    * We don't have GETUTENT, so we dig into utmp ourselves.
    * But we save the permanent filedescriptor and
    * open utmp just when we need to. 
    * This code supports an unsorted utmp. jw.
    */
#  define UTNOKEEP
# endif /* apollo || linux */
#endif

#ifndef UTMPFILE
# ifdef UTMP_FILE
#  define UTMPFILE	UTMP_FILE
# else
#  ifdef BSDI
#   define UTMPFILE	"/var/run/utmp"
#  else
#   define UTMPFILE	"/etc/utmp"
#  endif /* BSDI */
# endif
#endif

#ifdef SUIDROOT
#  ifdef LOCKPTY
#	 undef LOCKPTY
#  endif
#endif

#ifndef UTMPOK
#  ifdef USRLIMIT
#	 undef USRLIMIT
#  endif
#endif

#ifndef LOGINDEFAULT
#  define LOGINDEFAULT 0
#endif

#if defined(LOADAV_3DOUBLES) || defined(LOADAV_3LONGS) ||\
    defined(LOADAV_4LONGS) || defined(LOADAV_NEXT) ||\
    defined(LOADAV_GETLOADAVG)
#  define LOADAV
#endif

#ifndef FSCALE
# if defined(MIPS) || defined(SVR4)
#  define FSCALE 256            /* MIPS doesn't, and... */
# else
#  ifdef sgi
#   define FSCALE 1024.0
#  else /* sgi */
#   ifdef linux
#    define FSCALE (1 << 11)	/* is in /usr/include/linux/sched.h */
#   else /* linux */
#    define FSCALE 1000.0 	/* Sequent doesn't define FSCALE...grrrr */
#   endif /* linux */
#  endif /* sgi */
# endif	/* MIPS || SVR4 */
#endif /* FSCALE */

#ifndef F_OK
#define F_OK 0
#endif
#ifndef X_OK
#define X_OK 1
#endif
#ifndef W_OK
#define W_OK 2
#endif
#ifndef R_OK
#define R_OK 4
#endif

#ifndef S_IFIFO
#define S_IFIFO  0010000
#endif
#ifndef S_IREAD
#define S_IREAD  0000400
#endif
#ifndef S_IWRITE
#define S_IWRITE 0000200
#endif
#ifndef S_IEXEC
#define S_IEXEC  0000100
#endif

#if defined(S_IFIFO) && defined(S_IFMT) && !defined(S_ISFIFO)
#define S_ISFIFO(mode) ((mode & S_IFMT) == S_IFIFO)
#endif
#if defined(S_IFSOCK) && defined(S_IFMT) && !defined(S_ISSOCK)
#define S_ISSOCK(mode) ((mode & S_IFMT) == S_IFSOCK)
#endif

#ifndef TERMCAP_BUFSIZE
# define TERMCAP_BUFSIZE 1024
#endif /* TERMCAP_BUFSIZE */

#ifndef MAXPATH
# define MAXPATH 1024
#endif

#ifndef SIG_T_DEFINED
# ifdef SIGVOID
#  if defined(ultrix)
#   define sig_t void
#  else /* nice compilers: */
    typedef void sig_t;
#  endif
# else
   typedef int sig_t; /* (* sig_t) */
# endif
#endif /* SIG_T_DEFINED */

#if defined(SVR4) || (defined(SYSV) && defined(ISC)) || defined(_AIX) || defined(linux)
# define SIGPROTOARG   (int)
# define SIGDEFARG     int sigsig
# define SIGARG        0
#else
# define SIGPROTOARG   (void)
# define SIGDEFARG
# define SIGARG
#endif

#if (!defined(SYSV) && !defined(POSIX) && !defined(apollo)) /* || defined(sysV68) */
# ifndef PID_T_DEFINED
typedef int pid_t;
# endif /* PID_T_DEFINED */
#endif

#if defined(M_XENIX)
typedef int pid_t;
typedef int gid_t;
typedef int uid_t;
#endif

#if defined(UTMPOK) && defined(_SEQUENT_)
# define GETUTENT
#endif

#ifdef GETUTENT
  typedef char *slot_t;
#else
  typedef int slot_t;
#endif

#ifdef SYSV
# define index strchr
# define rindex strrchr
# ifdef __STDC__
#  define bcopy(s,d,len) memmove(d,s,len)
# endif
# define bzero(poi,len) memset(poi,0,len)
# define bcmp memcmp
# define killpg(pgrp,sig) kill( -(pgrp), sig)
# if defined(POSIX) && !defined(linux)
#  define signal sigset
# endif /* POSIX && !linux */
#endif /* SYSV */

#if defined(_POSIX_SOURCE) && defined(ISC)
# ifndef O_NDELAY
#  define O_NDELAY O_NONBLOCK
# endif
#endif

#ifdef hpux
# define setreuid(ruid, euid) setresuid(ruid, euid, -1)
# define setregid(rgid, egid) setresgid(rgid, egid, -1)
#endif

#if defined(_SEQUENT_) 
/* for the FD.. stuff */
# include <sys/select.h>
#endif /* _SEQUENT_ */

/*
#ifndef FD_SET
typedef struct fd_set
{
  int fd_bits[1];
}      fd_set;
# define FD_ZERO(fd) ((fd)->fd_bits[0] = 0)
# define FD_SET(b, fd) ((fd)->fd_bits[0] |= 1 << (b))
# define FD_ISSET(b, fd) ((fd)->fd_bits[0] & 1 << (b))
# define FD_SETSIZE 32
#endif
*/

#if !defined(SYSV) || defined(sun) || defined(RENO) || defined(xelos)
# define BSDWAIT
#endif

#if !defined(m68k) && !defined(M_XENIX)
# include <sys/wait.h>
#endif

#ifndef WTERMSIG
# ifndef BSDWAIT /* if wait is NOT a union: */
#  define WTERMSIG(status) (status & 0177)
# else
#  define WTERMSIG(status) status.w_T.w_Termsig 
# endif
#endif

#ifndef WSTOPSIG
# ifndef BSDWAIT /* if wait is NOT a union: */
#  define WSTOPSIG(status) ((status >> 8) & 0377)
# else
#  define WSTOPSIG(status) status.w_S.w_Stopsig 
# endif
#endif

#ifndef WIFCORESIG
# ifndef BSDWAIT /* if wait is NOT a union: */
#  define WIFCORESIG(status) (status & 0200)
# else
#  define WIFCORESIG(status) status.w_T.w_Coredump
# endif
#endif

#ifndef WEXITSTATUS
# ifndef BSDWAIT /* if wait is NOT a union: */
#  define WEXITSTATUS(status) ((status >> 8) & 0377)
# else
#  define WEXITSTATUS(status) status.w_T.w_Retcode
# endif
#endif

#if defined(sgi) 
/* on IRIX, regardless of the stream head's read mode (RNORM/RMSGN/RMSGD)
 * TIOCPKT mode causes data loss if our buffer is too small (IOSIZE)
 * to hold the whole packet at first read().
 * (Marc Boucher)
 */
# undef TIOCPKT
#endif

#if !defined(VDISABLE)
# ifdef _POSIX_VDISABLE
#  define VDISABLE _POSIX_VDISABLE
# else
#  define VDISABLE 0377
# endif /* _POSIX_VDISABLE */
#endif /* !VDISABLE */

#if !defined(FNDELAY) && defined(O_NDELAY)
# define FNDELAY O_NDELAY
#endif

/*typedef long off_t; */	/* Someone might need this */

/* 
 * 4 <= IOSIZE <=1000
 * you may try to vary this value. Use low values if your (VMS) system
 * tends to choke when pasting. Use high values if you want to test
 * how many characters your pty's can buffer.
 */
#define IOSIZE		4096

