/* Copyright (c) 1991
 *      Juergen Weigert (jnweiger@immd4.informatik.uni-erlangen.de)
 *      Michael Schroeder (mlschroe@immd4.informatik.uni-erlangen.de)
 * Copyright (c) 1987 Oliver Laumann
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Noteworthy contributors to screen's design and implementation:
 *	Wayne Davison (davison@borland.com)
 *	Patrick Wolfe (pat@kai.com, kailand!pat)
 *	Bart Schaefer (schaefer@cse.ogi.edu)
 *	Nathan Glasser (nathan@brokaw.lcs.mit.edu)
 *	Larry W. Virden (lvirden@cas.org)
 *	Howard Chu (hyc@hanauma.jpl.nasa.gov)
 *	Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
 *	Markku Jarvinen (mta@{cc,cs,ee}.tut.fi)
 *	Marc Boucher (marc@CAM.ORG)
 *
 ****************************************************************
 */
#include "rcs.h"
RCS_ID("$Id: loadav.c,v 1.4 92/11/05 00:54:25 jnweiger Exp $ FAU")

#include <sys/types.h>
#include <sys/param.h>
#include <fcntl.h>

#include "config.h"
#include "screen.h"

#include "extern.h"

#ifdef LOADAV


#if !defined (NeXT) && !defined(LOADAV_GETLOADAVG) && !defined(apollo)


/*
 * UnixName / AvenrunSymbol definition
 */

# ifndef linux
#  if defined(_SEQUENT_) || defined(MIPS) || defined(SVR4) || defined(ISC) || defined (sgi)
static char UnixName[] = "/unix";
#  else
#   ifdef sequent
static char UnixName[] = "/dynix";
#   else
#    ifdef hpux
static char UnixName[] = "/hp-ux";
#    else
#     ifdef xelos
static char UnixName[] = "/xelos";
#     else
static char UnixName[] = "/vmunix";
#     endif /* xelos */
#    endif /* hpux */
#   endif /* sequent */
#  endif /* _SEQUENT_ ... */
# endif /* linux */

# ifdef alliant
static char AvenrunSym[] = "_Loadavg";
# else /* alliant */
#  if defined(hpux) || defined(_SEQUENT_) || defined(SVR4) || defined(ISC) || defined(sgi)
static char AvenrunSym[] = "avenrun";
#  else
static char AvenrunSym[] = "_avenrun";
#  endif
# endif /* alliant */


/*
 * Header File includes
 */

# ifdef linux
static unsigned long k_addr __P((char *));
struct nlist
{
  unsigned long n_value;
};
# else
#  include <nlist.h>
#  ifndef NLIST_DECLARED
extern int nlist __P((char *, struct nlist *));
#  endif
# endif

static struct nlist nl[2];
static int kmemf;



#endif /* !NeXT && !LOADAV_GETLOADAVG && !apollo */



#ifndef NeXT

/*
 *     loadav[] definition
 */

#  ifdef LOADAV_3LONGS
static long loadav[3];
#  else
#   ifdef LOADAV_4LONGS
static long loadav[4];
#   else
static double loadav[3];
#   endif
#  endif

#endif /* NeXT */


static int avenrun;



/*
 *    Code
 */

#ifdef NeXT

# include <mach.h>

static processor_set_t default_set;

void
InitLoadav()
{
  kern_return_t error;

  error = processor_set_default(host_self(), &default_set);
  if (error != KERN_SUCCESS)
    mach_error("Error calling processor_set_default", error);
  else
    avenrun = 1;
}


void
AddLoadav(p)
char *p;
{
  kern_return_t error;
  unsigned int info_count;
  struct processor_set_basic_info info;
  host_t host;

  if (avenrun == 0)
    return;
  info_count = PROCESSOR_SET_BASIC_INFO_COUNT;
  error = processor_set_info(default_set, PROCESSOR_SET_BASIC_INFO, &host,
			     (processor_set_info_t)&info, &info_count);
  if (error != KERN_SUCCESS)
    {
      mach_error("Error calling processor_set_info", error);
      return;
    }
  sprintf(p, " %2.2f", (float)info.load_average / LOAD_SCALE);
}

#else /* NeXT */

void
InitLoadav()
{
  debug("Init Kmem...\n");
# if !defined(apollo) && !defined(LOADAV_GETLOADAVG)
  kmemf = open("/dev/kmem", O_RDONLY);
  if (kmemf == -1)
    return;
  debug("Kmem opened\n");
#  ifdef linux
  if ((nl[0].n_value = k_addr(AvenrunSym)) == -1)
    {
      close(kmemf);
      return;
    }
#  else /* linux */
  nl[0].n_name = AvenrunSym;
  debug2("Searching in %s for %s\n", UnixName, nl[0].n_name);
  nlist(UnixName, nl);
  if (/* nl[0].n_type == 0 || */ nl[0].n_value == 0)
    {
      close(kmemf);
      return;
    }
#   ifdef sgi
  nl[0].n_value &= ~(1 << 31);	/* clear upper bit */
#   endif /* sgi */
#  endif /* linux */
  debug1("AvenrunSym found (%ld)!!\n", nl[0].n_value);
# endif /* !apollo && !LOADAV_GETLOADAVG */
  avenrun = 1;
}

#ifdef apollo
# undef FSCALE
# define FSCALE 65536
#endif

void
AddLoadav(p)
char *p;
{
  if (avenrun == 0)
    return;
# ifdef LOADAV_GETLOADAVG
  getloadavg(loadav, sizeof(loadav)/sizeof(*loadav));
# else
#  ifdef apollo
  proc1_$get_loadav(loadav);
#  else /* apollo */
  debug1("GetAvenrun lseek %ld\n", nl[0].n_value);
  if (lseek(kmemf, (off_t) nl[0].n_value, 0) == (off_t) - 1)
    return;
  debug("... read\n");
  if (read(kmemf, (char *) loadav, sizeof(loadav)) != sizeof(loadav))
    return;
  debug("... o.k.\n");
#  endif /* apollo */
# endif /* LOADAV_GETLOADAVG */

# ifdef LOADAV_3LONGS
  sprintf(p, " %2.2f %2.2f %2.2f", (double) loadav[0] / FSCALE,
          (double) loadav[1] / FSCALE, (double) loadav[2] / FSCALE);
# else
#  ifdef LOADAV_4LONGS
  sprintf(p, " %2.2f %2.2f %2.2f %2.2f", (double) loadav[0] / 100,
	  (double) loadav[1] / 100, (double) loadav[2] / 100,
	  (double) loadav[3] / 100);
#  else
  sprintf(p, " %2.2f %2.2f %2.2f", loadav[0], loadav[1], loadav[2]);
#  endif /* LOADAV_4LONGS */
# endif /* LOADAV_3LONGS */
}

#endif /* NeXT */




#ifdef linux
/*
 * Linux specific code stolen from ps-0.97.4, (psdata.[ch])
 * Copyright (c) 1992 Branko Lancester
 *
 * All chrome removed -- works at least for 0.97p5. jw.
 */

struct dbtbl_s {
    off_t		off;		/* offset in psdatabase */
    int			nsym;		/* # symbols */
    int			size;		/* size of array + strings */
};

/*
 * header of psdatabase
 */
struct psdb_hdr {
    char		magic[16];
    char		uts_release[8];
    char		uts_version[8];
    char		sys_path[128];	/* name of system binary */
    char		swap_path[128];	/* name of system binary */
    struct dbtbl_s	vars;		/* bss and data symbols */
    struct dbtbl_s	fncs;		/* list of all functions */
    struct dbtbl_s	ttys;	/* device names (currently unused) */
};

struct sym_s {
    unsigned long	addr;		/* core address in kernel */
    int			name;		/* offset from strings ptr */
};

struct tbl_s {
    struct sym_s	*tbl;
    int			nsym;
    char		*strings;	/* ptr to start of strings */
} vars;

/*
 * vars are sorted on name
 */
static int
varcmp(p1, p2)
struct sym_s *p1, *p2;
{
    return(strcmp(vars.strings + p1->name, vars.strings + p2->name));
}

/*
 * This version of k_addr() is a one shot item. Not to be used often.
 * jw.
 */

/*
 * get address of data symbol
 */
static unsigned long
k_addr(sym)
char *sym;
{
    struct psdb_hdr db_hdr;
    struct sym_s *p = NULL, key;
    int psdb = -1;

    debug("k_addr:\n");
    if ((psdb = open("/etc/psdatabase", O_RDONLY)) == -1)
      return -1;
    while (read(psdb, (char *)&db_hdr, sizeof db_hdr) == sizeof db_hdr)
      {
        char buf[db_hdr.vars.size];

	debug(".. psdb open, hdr\n");
	if (lseek(psdb, db_hdr.vars.off, 0) == -1)
	  break;
        debug1(".. lseek (%d)\n", db_hdr.vars.off);
	if (read(psdb, buf, sizeof buf) != sizeof buf)
	  break;
        debug(".. psdb read!\n");
	vars.tbl = (struct sym_s *)buf;
	vars.nsym = db_hdr.vars.nsym;
	vars.strings = (char *) (vars.tbl + vars.nsym);

	key.name = sym - vars.strings;
	p = (struct sym_s *) bsearch(&key, vars.tbl, vars.nsym,
				    sizeof(struct sym_s), varcmp);
	break;
      }
    close(psdb);
    return(p ? p->addr : -1);
}


#endif /* linux */

#endif /* LOADAV */
