/* Copyright (c) 1991
 *      Juergen Weigert (jnweiger@immd4.informatik.uni-erlangen.de)
 *      Michael Schroeder (mlschroe@immd4.informatik.uni-erlangen.de)
 * Copyright (c) 1987 Oliver Laumann
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Noteworthy contributors to screen's design and implementation:
 *	Wayne Davison (davison@borland.com)
 *	Patrick Wolfe (pat@kai.com, kailand!pat)
 *	Bart Schaefer (schaefer@cse.ogi.edu)
 *	Nathan Glasser (nathan@brokaw.lcs.mit.edu)
 *	Larry W. Virden (lvirden@cas.org)
 *	Howard Chu (hyc@hanauma.jpl.nasa.gov)
 *	Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
 *	Markku Jarvinen (mta@{cc,cs,ee}.tut.fi)
 *	Marc Boucher (marc@CAM.ORG)
 *
 ****************************************************************
 */

#include "rcs.h"
RCS_ID("$Id: exec.c,v 1.5 92/11/19 11:55:50 mlschroe Exp Locker: jnweiger $ FAU")

#include <sys/types.h>
#include <signal.h>

#include "config.h"
#include "screen.h"
#include "extern.h"

char DefaultShell[] = "/bin/sh";
static char DefaultPath[] = ":/usr/ucb:/bin:/usr/bin";

void execvpe(prog, args, env)
char *prog, **args, **env;
{
  register char *path, *p;
  char buf[1024];
  char *shargs[MAXARGS + 1];
  register int i, eaccess = 0;

  if (prog[0] == '/')
    path = "";
  else if ((path = getenv("PATH")) == 0)
    path = DefaultPath;
  do
    {
      p = buf;
      while (*path && *path != ':')
	*p++ = *path++;
      if (p > buf)
	*p++ = '/';
      strcpy(p, prog);
      if (*path)
	++path;
      execve(buf, args, env);
      switch (errno)
	{
	case ENOEXEC:
	  shargs[0] = DefaultShell;
	  shargs[1] = buf;
	  for (i = 1; (shargs[i + 1] = args[i]) != NULL; ++i)
	    ;
	  execve(DefaultShell, shargs, env);
	  return;
	case EACCES:
	  eaccess = 1;
	  break;
	case ENOMEM:
	case E2BIG:
	case ETXTBSY:
	  return;
	}
    } while (*path);
  if (eaccess)
    errno = EACCES;
}

void
winexec(d, s)
struct display *d;
char *s;
{
#if 0
  int pid;

  switch (pid = fork())
    {
    case -1:
      Msg(errno, "fork");
      return;
    case 0:
      signal(SIGHUP, SIG_DFL);
      signal(SIGINT, SIG_DFL);
      signal(SIGQUIT, SIG_DFL);
      signal(SIGTERM, SIG_DFL);
#ifdef BSDJOBS
      signal(SIGTTIN, SIG_DFL);
      signal(SIGTTOU, SIG_DFL);
#endif
      if (setuid(real_uid) || setgid(real_gid))
	{
	  SendErrorMsg("Setuid/gid: %s", sys_errlist[errno]);
	  eexit(1);
	}
      if (nwin.dir && *nwin.dir && chdir(nwin.dir) == -1)
	{
	  SendErrorMsg("Cannot chdir to %s: %s", nwin.dir, sys_errlist[errno]);
	  eexit(1);
	}

      if (display)
	{
	  brktty(userfd);
	  freetty();
	}
      else 
	brktty(-1);
#ifdef DEBUG
      if (dfp != stderr)
	fclose(dfp);
#endif
      closeallfiles();
#ifdef DEBUG
      if ((dfp = fopen("/tmp/debug/screen.winexec", "w")) == 0)
        dfp = stderr;
      else
        (void) chmod("/tmp/debug/screen.winexec", 0666);
#endif
      /*
       * open and dup 0, 1, 2
       * HERE!!!
       */
      if (fgtty(0))
        SendErrorMsg("fgtty: %s (%d)", sys_errlist[errno], errno);
      if (display)
        SetTTY(0, &OldMode);
      else
        {
  	  struct mode Mode;
  	  debug("No display - creating tty setting\n");
	  InitTTY(&Mode);
#ifdef DEBUG
	  DebugTTY(&Mode);
#endif
	  SetTTY(0, &Mode);
        }
      debug1("winexec execl(\"/bin/sh\", \"sh(screen)\", \"-c\", \"%s\")\n", s);
      execl("/bin/sh", "sh(screen)", "-c", s);
      debug1("winexec error: %d\n", errno);
    default:
      /* 
       * This is not nice. We block the complete screen session here
       * jw.
       */
      while ((errno = 0, i = wait(&wstat)) != pid)
	if (i < 0 && errno != EINTR)
	  break;
      debug2("winexec: '%s' done. WEXITSTATUS=  %d\n", s, WEXITSTATUS(wstat));
    } 
#endif
}
