/* Copyright (c) 1991
 *      Juergen Weigert (jnweiger@immd4.informatik.uni-erlangen.de)
 *      Michael Schroeder (mlschroe@immd4.informatik.uni-erlangen.de)
 * Copyright (c) 1987 Oliver Laumann
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Noteworthy contributors to screen's design and implementation:
 *	Wayne Davison (davison@borland.com)
 *	Patrick Wolfe (pat@kai.com, kailand!pat)
 *	Bart Schaefer (schaefer@cse.ogi.edu)
 *	Nathan Glasser (nathan@brokaw.lcs.mit.edu)
 *	Larry W. Virden (lvirden@cas.org)
 *	Howard Chu (hyc@hanauma.jpl.nasa.gov)
 *	Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
 *	Markku Jarvinen (mta@{cc,cs,ee}.tut.fi)
 *	Marc Boucher (marc@CAM.ORG)
 *
 ****************************************************************
 * $Id: display.h,v 1.4 92/11/19 17:55:42 mlschroe Exp $ FAU
 */


struct win;			/* forward declaration */

struct display
{
  struct display *d_next;		/* linked list */
  char  d_user[20 + 1];		/* username */
  struct LayFuncs *d_layfn;	/* current layer functions */
  struct layer *d_lay;		/* layers on the display */
  struct win *d_dfore;		/* pointer to fore window */
  struct win *d_other;		/* pointer to other window */
  char  d_termname[20 + 1];	/* $TERM */
  char	d_tentry[TERMCAP_BUFSIZE];	/* buffer for tgetstr */
  int	d_tcinited;		/* termcap inited flag */
  int	d_width, d_height;	/* width/height of the screen */
  int	d_defwidth, d_defheight;	/* default width/height of windows */
  int	d_top, d_bot;		/* scrollregion start/end */
  int	d_curx, d_cury;		/* cursor position */
  char	d_attr;			/* current attributes */
  char	d_font;			/* current font */
  int	d_insert;		/* insert mode flag */
  int	d_keypad;		/* application keypad flag */
  int	d_cursorkeys;		/* application cursorkeys flag */
  int	d_flow;			/* flow control on/off flag*/
  int	d_lp_missing;		/* last character on bot line missing */
  int	d_lp_image;		/* missing image */
  int	d_lp_attr;		/* missing attr */
  int	d_lp_font;		/* missing font */
  int	d_status;		/* is status displayed? */
  time_t d_status_time;		/* time of status display */
  int	d_status_bell;		/* is it only a vbell? */
  int	d_status_len;		/* length of status line */
  char  *d_status_lastmsg;	/* last displayed message */
  int   d_status_buflen;	/* last message buffer len */
  int	d_status_lastx;		/* position of the cursor */
  int	d_status_lasty;		/*   before status was displayed */
  int	d_ESCseen;		/* Was the last char an ESC (^a) */
  int	d_userpid;		/* pid of attacher */
  char	d_usertty[MAXPATH];	/* tty we are attached to */
  int	d_userfd;		/* fd of the tty */
  struct mode d_OldMode;	/* tty mode when screen was started */
  struct mode d_NewMode;	/* New tty mode */
  char  *d_obuf;		/* output buffer */
  int   d_obuflen;		/* len of buffer */
  int	d_obufmax;		/* len where we are blocking the pty */
  char  *d_obufp;		/* pointer in buffer */
  int   d_obuffree;		/* free bytes in buffer */
#ifdef AUTO_NUKE
  int	d_auto_nuke;		/* autonuke flag */
#endif
#ifdef COPY_PASTE
  char	*d_copybuffer;
  int	d_copylen;
  char	*d_pastebuffer;
  int	d_pastelen;
#endif
  union	tc d_tcs[T_N];		/* terminal capabilities */
  char	*d_attrtab[NATTR];
  short	d_dospeed;			/* baudrate of tty */
  char d_c0_tab[256];		/* conversion for C0 */
  int d_UPcost, d_DOcost, d_LEcost, d_NDcost;
  int d_CRcost, d_IMcost, d_EIcost, d_NLcost;
#ifdef UTMPOK
  slot_t d_loginslot;		/* offset, where utmp_logintty belongs */
  struct utmp d_utmp_logintty;	/* here the original utmp structure is stored */
# ifdef _SEQUENT_
  char d_loginhost[100+1];
# endif /* _SEQUENT_ */
#endif
};

#ifdef MULTI
# define DISPLAY(x) display->x
#else
extern struct display TheDisplay;
# define DISPLAY(x) TheDisplay.x
#endif

#define user		DISPLAY(d_user)
#define layfn		DISPLAY(d_layfn)
#define lay		DISPLAY(d_lay)
#define dfore		DISPLAY(d_dfore)
#define other		DISPLAY(d_other)
#define termname	DISPLAY(d_termname)
#define tentry		DISPLAY(d_tentry)
#define tcinited	DISPLAY(d_tcinited)
#define width		DISPLAY(d_width)
#define height		DISPLAY(d_height)
#define defwidth	DISPLAY(d_defwidth)
#define defheight	DISPLAY(d_defheight)
#define top		DISPLAY(d_top)
#define bot		DISPLAY(d_bot)
#define curx		DISPLAY(d_curx)
#define cury		DISPLAY(d_cury)
#define attr		DISPLAY(d_attr)
#define font		DISPLAY(d_font)
#define insert		DISPLAY(d_insert)
#define keypad		DISPLAY(d_keypad)
#define cursorkeys	DISPLAY(d_cursorkeys)
#define flow		DISPLAY(d_flow)
#define lp_missing	DISPLAY(d_lp_missing)
#define lp_image	DISPLAY(d_lp_image)
#define lp_attr		DISPLAY(d_lp_attr)
#define lp_font		DISPLAY(d_lp_font)
#define status		DISPLAY(d_status)
#define status_time	DISPLAY(d_status_time)
#define status_bell	DISPLAY(d_status_bell)
#define status_len	DISPLAY(d_status_len)
#define status_lastmsg	DISPLAY(d_status_lastmsg)
#define status_buflen	DISPLAY(d_status_buflen)
#define status_lastx	DISPLAY(d_status_lastx)
#define status_lasty	DISPLAY(d_status_lasty)
#define ESCseen		DISPLAY(d_ESCseen)
#define userpid		DISPLAY(d_userpid)
#define usertty		DISPLAY(d_usertty)
#define userfd		DISPLAY(d_userfd)
#define OldMode		DISPLAY(d_OldMode)
#define NewMode		DISPLAY(d_NewMode)
#define obuf		DISPLAY(d_obuf)
#define obuflen		DISPLAY(d_obuflen)
#define obufmax		DISPLAY(d_obufmax)
#define obufp		DISPLAY(d_obufp)
#define obuffree	DISPLAY(d_obuffree)
#define auto_nuke	DISPLAY(d_auto_nuke)
#define copybuffer	DISPLAY(d_copybuffer)
#define copylen		DISPLAY(d_copylen)
#define pastebuffer	DISPLAY(d_pastebuffer)
#define pastelen	DISPLAY(d_pastelen)
#define tcs		DISPLAY(d_tcs)
#define attrtab		DISPLAY(d_attrtab)
#define dospeed		DISPLAY(d_dospeed)
#define c0_tab		DISPLAY(d_c0_tab)
#define UPcost		DISPLAY(d_UPcost)
#define DOcost		DISPLAY(d_DOcost)
#define LEcost		DISPLAY(d_LEcost)
#define NDcost		DISPLAY(d_NDcost)
#define CRcost		DISPLAY(d_CRcost)
#define IMcost		DISPLAY(d_IMcost)
#define EIcost		DISPLAY(d_EIcost)
#define NLcost		DISPLAY(d_NLcost)
#define loginslot	DISPLAY(d_loginslot)
#define utmp_logintty	DISPLAY(d_utmp_logintty)
#define loginhost	DISPLAY(d_loginhost)


#define GRAIN 4096  /* Allocation grain size for output buffer */
#define OBUF_MAX 256
   /* Maximum amount of buffered output before input is blocked */

#define OUTPUT_BLOCK_SIZE 256  /* Block size of output to tty */

#define AddChar(c) \
  { \
    if (--obuffree == 0) \
      Resize_obuf(); \
    *obufp++ = (c); \
  }

