/*
 * bsd_fossil.c
 *
 * BSD implementation of the Video Fossil functions
 *
 * BinkleyTerm only uses:
 *   VioWrtTTY
 *   VioWrtCellStr
 *
 * Refer to FSC-0021 for more details
 */

#include <stdio.h>
#include <curses.h>

#include "bink.h"
#include "com.h"
#include "sbuf.h"
#include "sched.h"
#include "externs.h"
#include "prototyp.h"
#include "vfossil.h"

extern VIOMODEINFO vfos_mode;

/*
 * Initialise video Fossil routines
 */

void vfossil_init(void)
{
#ifdef NEXTDEBUG
	fprintf(stderr, "vfossil_init\n");
#endif

	initscr();
	cbreak();
	noecho();
	vfos_mode.col = COLS;	/* Number of text columns */
	vfos_mode.row = LINES;	/* Number of test rows */
	vfos_mode.color = 2;	/* Number of colours */
	/* monitor type either.. mono/text/no_color, or other/text/color */
	vfos_mode.fbType = 1;
    vfossil_installed = 1;
}

void vfossil_close(void)
{
#ifdef NEXTDEBUG
	fprintf(stderr, "vfossil_close\n");
#endif
	vfossil_installed = 0;
	endwin();
}

/* 
 * Enable or disable cursor
 */

void vfossil_cursor (int st)
{
}

/*
 * Write a Cell string
 *
 * Note that the string is in Character/Attribute pairs
 *
 * Map the Attribute to Atari colours.  Of course this isnt going to
 * work very well in mono is it!
 */

void VioWrtCellStr(BYTEBUFP s, size_t len, int row, int column, int vhandle)
{
/* fprintf(stderr, "VIO move to %03d, %03d\n", column, row); */
	move(row, column);
	len /= 2;		/* length is actually byte length */
	
	while(len--)
	{
		if(s->ch)
			addch(s->ch);		/* Raw output */
		else
			addch(' ');
		s++;
	}
	refresh();
}

void fossil_gotoxy (int x, int y)
{
/* fprintf(stderr, "std move to %03d, %03d\n", x, y);*/
	move(y, x);
}

int fossil_wherex (void)
{
	return stdscr->_curx;
}

int fossil_wherey (void)
{
	return stdscr->_cury;
}

void screen_clear(void)
{
	clear();
	refresh();
}
void clear_eol(void)
{
	clrtoeol();
	refresh();
}

void _WRITE_ANSI(int ch)
{
	switch(ch) {
		case '\r':
			move(stdscr->_cury, 0);
			break;
		case '\n':
			move(stdscr->_cury+1, stdscr->_curx);
			break;
		default:
			addch(ch);
			break;
	}
}

void WRITE_ANSI(int ch)
{
	_WRITE_ANSI(ch);
	refresh();
}

void WRITE_ANSI_STR(char *string)
{
	while (*string != 0)
		_WRITE_ANSI (*string++);
	refresh();
}
