# Makefile for BinkleyTerm-ST 3.00
# Compile with Lattice C 5.

# Define C flags:

CFLAGS = -d -r0 -cakisft -v -ma -DBINKLEY -DATARIST -DNEW -w -j88e86e100e85e87e

# Assembler flags (enable debugging)

ASFLAGS = -d -dLATTICE -u

# Link flags (Use word library)

RUN = FROM cs.o
LNFLAGS =  XADDSYM BATCH VERBOSE
LIBS = LIB lcs.lib

# Object files
# First those for the main BinkleyTerm module

COBJS = bt.o   btconfig.o misc.o	 b_help.o   \
	mdm_proc.o b_script.o b_fuser.o  nodeproc.o langload.o \
	b_proto.o  b_bbs.o	  b_search.o b_sessio.o recvbark.o \
	yoohoo.o   b_wazoo.o  b_wzsend.o ftsc.o 	mailer.o   \
	sendbark.o sched.o	  b_passwo.o b_frproc.o sbuf.o \
	zreceive.o zsend.o	  zmisc.o	 \
	data.o	   b_termov.o b_banner.o b_initva.o stvfosil.o \
	b_sbinit.o b_flofil.o evtparse.o \
	b_spawn.o  b_rspfil.o b_term.o   \
	xmsend.o   m7send.o   bsend.o	 brec.o 	xmrec.o    \
	m7rec.o    janus.o	  statetbl.o outbound.o overlay.o  \
	mailroot.o com_st.o version.o emsi.o logfile.o

# Next those for BTCTL, the program that makes a dummy OMMM CTL file

COBJ1 = btctl.o

# Then those for BTLNG, Bink's language compiler

COBJ2 = btlng.o get_lang.o put_lang.o

# Assembler files
# Object files that ASM is responsible for generating

MOBJS = bink_asm.o

# Combined all object files that bt.prg needs

BTALLOBS = $(COBJS) $(MOBJS)

#
# Dependency list for regular and debug version, and LINK
# command lines
#

all: binkley.lng bt.ttp btctl.tos btlng.ttp
	@echo "Made $@"

binkley.lng : btlng.ttp english.txt
	btlng english.txt $@

# I hope clink can handle the huge command line!!!

bt.ttp: $(BTALLOBS) bt.lnk
	$(LN) WITH bt.lnk TO $@
	echo

btctl.tos: $(COBJ1)
	$(LN) $(RUN) FROM $(COBJ1) TO $@ $(LIBS) $(LNFLAGS)
	echo

btlng.ttp: $(COBJ2)
	$(LN) $(RUN) FROM $(COBJ2) TO $@ $(LIBS) $(LNFLAGS) 
	echo

bt.lnk: makefile.st
	@echo "Making $@"
	@echo $(RUN) >! $@
	@echo $(LNFLAGS) >>! $@
	@echo FROM $(BTALLOBS) >>! $@
	@echo $(LIBS) >>! $@

#----------------
# All the dependencies... Generated with Greps and things to be accurate

####
# Dependant .h files
####

bink.h: externs.h prototyp.h logfile.h
	touch $@

com.h: com_st.h
	touch $@

vfossil.h: sbuf.h
	touch $@

####
# Dependant .o files
####

b_banner.o: bink.h msgs.h com.h vfossil.h sbuf.h externs.h prototyp.h

b_bbs.o: bink.h msgs.h sched.h sbuf.h com.h vfossil.h

b_flofil.o: bink.h msgs.h com.h zmodem.h session.h

b_frproc.o: bink.h msgs.h sbuf.h sched.h session.h password.h ascii.h com.h vfossil.h zmodem.h

b_fuser.o: bink.h

b_help.o: bink.h msgs.h com.h keybd.h

b_initva.o: bink.h msgs.h com.h sbuf.h sched.h zmodem.h vfossil.h defines.h

b_passwo.o: bink.h msgs.h password.h nodeproc.h

b_proto.o: bink.h msgs.h com.h

b_rspfil.o: bink.h msgs.h session.h fsc.h

b_sbinit.o: bink.h msgs.h sbuf.h vfossil.h sched.h

b_script.o: bink.h msgs.h sbuf.h vfossil.h com.h ascii.h

b_search.o: bink.h msgs.h com.h keybd.h ascii.h nodeproc.h

b_sessio.o: bink.h msgs.h sbuf.h sched.h emsi.h session.h com.h defines.h wazoo.h

b_spawn.o: bink.h msgs.h sbuf.h com.h vfossil.h

b_term.o: bink.h msgs.h sbuf.h keybd.h vfossil.h com.h zmodem.h nodeproc.h

b_termov.o: bink.h msgs.h com.h keybd.h sbuf.h ascii.h nodeproc.h

b_wazoo.o: bink.h msgs.h com.h session.h zmodem.h wazoo.h

b_wzsend.o: bink.h msgs.h com.h zmodem.h defines.h wazoo.h session.h

brec.o: bink.h msgs.h com.h sbuf.h defines.h ascii.h vfossil.h

bsend.o: bink.h msgs.h com.h sbuf.h defines.h ascii.h vfossil.h

bt.o: bink.h msgs.h sbuf.h vfossil.h com.h session.h

btconfig.o: bink.h msgs.h keybd.h com.h sbuf.h vfossil.h config.h nodeproc.h

btlng.o: language.h

com_st.o: bink.h com.h

conio.o: conio.h

data.o: bink.h com.h keybd.h sched.h zmodem.h sbuf.h vfossil.h

emsi.o: bink.h msgs.h emsi.h com.h sbuf.h zmodem.h wazoo.h version.h password.h session.h defines.h sched.h nodeproc.h

evtparse.o: bink.h msgs.h sched.h

ftsc.o: bink.h msgs.h com.h ascii.h defines.h wazoo.h session.h password.h nodeproc.h

get_lang.o: language.h

janus.o: bink.h msgs.h com.h sbuf.h vfossil.h janus.h zmodem.h wazoo.h defines.h session.h password.h

langload.o: bink.h msgs.h

logfile.o: bink.h logfile.h externs.h msgs.h vfossil.h sbuf.h zmodem.h

m7rec.o: bink.h msgs.h com.h sbuf.h defines.h ascii.h vfossil.h

m7send.o: bink.h msgs.h com.h sbuf.h defines.h ascii.h vfossil.h

mailer.o: bink.h msgs.h sbuf.h com.h vfossil.h sched.h keybd.h zmodem.h session.h nodeproc.h

mailroot.o: bink.h msgs.h com.h sched.h sbuf.h session.h defines.h vfossil.h nodeproc.h

mdm_proc.o: bink.h msgs.h com.h zmodem.h sbuf.h sched.h nodeproc.h

misc.o: bink.h msgs.h com.h sbuf.h vfossil.h sched.h defines.h zmodem.h snserver.h

nodeproc.o: bink.h msgs.h com.h nodeproc.h

outbound.o: bink.h msgs.h sbuf.h defines.h zmodem.h

overlay.o: bink.h sbuf.h

put_lang.o: language.h

recvbark.o: bink.h msgs.h defines.h com.h session.h ascii.h

sbuf.o: bink.h sbuf.h video.h box.h keybd.h ascii.h com.h vfossil.h

sched.o: bink.h msgs.h sbuf.h sched.h com.h vfossil.h

sendbark.o: bink.h msgs.h com.h ascii.h defines.h

statetbl.o: bink.h

stvfosil.o: bink.h com_st.h vfossil.h keybd.h

version.o: version.h

xmrec.o: bink.h msgs.h com.h sbuf.h defines.h ascii.h vfossil.h session.h nodeproc.h

xmsend.o: bink.h msgs.h com.h sbuf.h defines.h ascii.h vfossil.h

yoohoo.o: bink.h msgs.h com.h sbuf.h version.h session.h password.h wazoo.h nodeproc.h

zmisc.o: bink.h msgs.h sbuf.h zmodem.h com.h vfossil.h session.h

zreceive.o: bink.h msgs.h sbuf.h zmodem.h com.h vfossil.h session.h

zsend.o: bink.h msgs.h sbuf.h zmodem.h com.h vfossil.h session.h wazoo.h

#------------------------------
