#!/bin/sh
# Script ----------------------------------------------------------------------
# Description - Pwutil is a front end to the rest of the pw utils.
# License     - See LICENSE file for details.
#
# $Author: jayrfink $
# $Date: 2007/06/20 01:20:30 $
# $State: Exp $
#------------------------------------------------------------------------------

progname=${0##*/}
toppid=$$
results=/dev/null
trap "exit 1" 1 2 3 15

bomb()
{
    cat >&2 <<ERRORMESSAGE

ERROR: $@
*** ${progname} aborted ***
ERRORMESSAGE
    kill ${toppid}
    exit 1
}

do_cmd()
{
	cmd=$1
	shift
	args=$@
	$cmd $args || bomb "Could not execute ${cmd} ${args} "
}

usage()
{
	cat <<_usage_
Usage: ${progname} [command_option [args]]
Usage: ${progname} [-gr|-g arg1 arg2 arg3...|-ud|-ur|-ui arg1 arg2...|-uq arg]
Usage: ${progname} [-gr|-g usr1 usr2 usr3...|-ud|-ur|-ui usr1 usr2...]-uq expr]
Usage: ${progname} -usage
Command Options:
    -gr          Run a report on user groups.
    -g users..   Show what groups a user or users are in.
    -ud          Display space usage in all user home directories in kb.
    -ur          Run a report on users.
    -ui users... Get userinformation for a user or userlist.
    -uq PATTERN  Get data on all usernames that match pattern PATTERN.
_usage_
}

# Input parsing - the usage explains what each one does
if [ $# -gt 0 -a "$1" = "-h" ];then
    usage
    exit 0
fi
if [ $# -gt 0 -a "$1" = "--help" ];then
    usage
    exit 0
fi  

while [ "$#" -gt "0" ]; do
    case $1 in
		-usage) usage ; exit 0 ;;
		-gr) do_cmd pwgrprep ;;
		-g) shift ; do_cmd pwgrps $@ ;;
		-ud) do_cmd pwdf ;;
		-ur) do_cmd pwuserep ;;
		-ui) shift ; do_cmd pwuser $@ ;;
		-uq) shift ; do_cmd pwquery $@ ;;
		*) usage ; exit 1 ;;
	esac
shift
done

exit  0
