#!/usr/bin/env python
# Script ----------------------------------------------------------------------
# Description - Pwuserep prints out a report about users.
# License     - See LICENSE file for details.
#
# $Author: jayrfink $
# $Date: 2007/05/31 23:33:45 $
# $State: Exp $
#------------------------------------------------------------------------------


import grp # Import the group db API
import pwd # Import the passwd db API

def fixup_userinfo(pwent): # Fixup the fields from pwdb API calls
	try:
		grinfo = grp.getgrgid(pwent[3])
	except:
		grinfo = "?"

	return pwent[0], pwent[2], pwent[3], grinfo[0] ,pwent[5], pwent[6],

def printfields(row):      # Format the coloums and rows
	k = 0
	for j in row:
		if k == 0:
			print str(j).ljust(11),
		elif k == 1:
			print str(j).ljust(5),
		elif k == 2:
			print str(j).ljust(5),
		elif k == 3:
			print str(j).ljust(12),
		elif k == 4:
			print str(j).ljust(20),
		else:
			print str(j).ljust(16)
		k = k + 1

# Main

# Initially print out a header
printfields(('Name','UID','GID','Pri Group','Home Dir','Shell'))
allpwent = pwd.getpwall() # Get all pwdb entries

for i in allpwent:        # For each entry, print out a row
	printfields(fixup_userinfo(i))

