/* Program ------------------------------------------------------------------
 *
 * Dexcription - Pwuser looks up all of the fields in the pwdb and prints
 *               them out for valid users. Invalidusers pop out a not
 *               found error and the program continues through the list.
 *
 * $Author: jayrfink $
 * $Date: 2007/05/31 23:03:08 $
 * $State: Exp $
 *
 -----------------------------------------------------------------------------*/

#include <grp.h>
#include <pwd.h>

#include <sys/types.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define PN "pwuser"

void getuserinfo (char *username);
void usage (void);

/*
 * getuserinfo: required - username
 *              return   - none
 */
void getuserinfo (char *username) 
{
	struct passwd *user_pwd_info;
	struct group  *user_grp_info;
	char          **user_members;

	user_pwd_info = getpwnam(username);

	if (!user_pwd_info) {
		printf("Could not find info about user %s\n", username);
		return;
	}

	user_grp_info = getgrgid(user_pwd_info->pw_gid);

	printf("UserID: %d\n", user_pwd_info->pw_uid);
	printf("GroupID: %d\n", user_pwd_info->pw_gid);
	printf("Username: %s\n", user_pwd_info->pw_name);
	printf("Default Group: %s\n", user_grp_info->gr_name);
	printf("Home Directory: %s\n", user_pwd_info->pw_dir);
	printf("Default Login Shell: %s\n", user_pwd_info->pw_shell);
	printf("Misc Information: %s\n", user_pwd_info->pw_gecos);
}

/*
 * usage: required - none
 *        returned - none
 */
void usage (void)
{
		printf("Usage: %s [arg1 arg2 arg3...]\n", PN);
		printf("Usage: %s [user1 user2 user3...]\n", PN);
		printf("Usage: usage\n");
}

/*
 * Main: required - opts and args
 *       returned - exit status
 */
int main (int argc, char *argv[])
{
		int c;

		if (argc <= 1) {
				printf("Syntax error\n");
				usage();
				return 1;
		}

		if (strcmp(argv[1], "usage") == 0) {
				usage();
				return 0;
		}

		for (c = 1; c < argc; c++) {
				getuserinfo(argv[c]);

				if (argv[c + 1])
						printf("\n");

		}

		return 0;
}

