/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef CACHE_H
#define CACHE_H

#include <pth.h>
#include <glib.h>
#include "status.h"

typedef struct {
    guchar filename[16];	/* MD5 hash. */
    guchar key[32];		/* SHA256 */
    glong timeout;		/* adjust_cache_time_thread(). */
    glong reset;		/* To reset .timeout. */
    pth_mutex_t *mutex;
    gint refcount;		/* The number of associated clients. */
} file_cache_t;

GSList *key_cache;
pth_mutex_t cache_mutex;

void cache_adjust_timer(void);
gboolean cache_set_timeout(const guchar *md5filename, glong timeout);
gboolean cache_reset_timeout(const guchar *md5filename, glong timeout);
gboolean cache_iscached(const guchar *md5filename);
gboolean cache_clear(const guchar *md5filename, gint which);
gboolean cache_add_file(const guchar *md5file, const guchar *shakey);
gboolean cache_get_key(const guchar *md5file, guchar *shakey);
gboolean cache_update_key(const guchar *md5filename, const guchar *shakey);
gint cache_file_count(void);
gboolean cache_has_file(const guchar *md5file);
gboolean cache_get_mutex(const guchar *md5filename, pth_mutex_t **result);
gboolean cache_decr_refcount(const guchar *md5filename);
gboolean cache_incr_refcount(const guchar *md5filename);
void cache_free();

#endif
