/*******************************************************************

Eric R. Weeks (weeks@physics.emory.edu)

Information about this program at:
http://www.physics.emory.edu/~weeks/graphics/colorps.html

This program may be freely distributed as long as this
header is unchanged.

palette.c taken from qcell.c (perhaps v05 ?)
started from cell1.c (v02), shell.c, quasi.c (v03)

palette v4:  8-10-95	I want more stuff on the printout
palette v5:  5-12-96	redo ordering of colors to be nice

Amended by Mike Eggleston (11-01-2005) to show CMY levels as 2 digit hex

NOTE:  0     = black when using setgray
       0,0,0 = black when using setrgbcolor

 *******************************************************************/
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#define PI 3.14159265358979323846264338328
#define EE 2.71828182845904523536
/* following two parameters are PostScript linewidths (in cm) */
#define BOXLINE 0.015
#define FIELDLINE 0.015
#define MAXCELLS 50000
#define INFECT 2953

/* 1526 */

/* --- function declarations --- */
int plot();
double getdx();
void printheader();
void printtrailer();
void plotcell();
void printcolor();

/* --- variables used only by 'plot' subroutine --- */
double window;
double oldx,oldy;
double xcen,ycen;			/* center of picture */
double scale;
float offsetx,offsety;
int oldflag,rotate,gridon;
int setcolor;

/* --- variables used by whole program --- */
char *prgname;
float color[2][4];
int num;
int coloron;

int rrr;
int ttt;
int target[37];
float thecolors[3][10];


void getcolor()
{
	int r;
	float aa,bb,cc;
	int col1,col2;

			/* the integer 't' is the number of the box we are printing */
	ttt++;		/* start with t=0 */

	col1 = target[rrr];
	col2 = target[rrr+1];

	r = ttt % 6;
	cc = (thecolors[0][col2]*((float)r)+thecolors[0][col1]*((float)(6-r)))/6.0;
	bb = (thecolors[1][col2]*((float)r)+thecolors[1][col1]*((float)(6-r)))/6.0;
	aa = (thecolors[2][col2]*((float)r)+thecolors[2][col1]*((float)(6-r)))/6.0;
	color[0][1] = cc;
	color[0][2] = bb;
	color[0][3] = aa;
	if (r==5) rrr++;
/*	fprintf(stderr,"%d %d\n",ttt,rrr);   Mike 11-01-2005 */
}



/*  M   M   AAA   IIIII  N   N
 *  MM MM  A   A    I    NN  N
 *  M M M  AAAAA    I    N N N   ************************************
 *  M   M  A   A    I    N  NN
 *  M   M  A   A  IIIII  N   N
 */


main(argc,argv)
int argc;
char **argv;
{
	int e,bit;
	register int r,a;
	double aa,bb,col,cc;
	double z[8],x,y;
	double magnify;
	int b,c;
	FILE *fp, *fopen();
	extern int optind;
	extern char *optarg;
	double size;
        int hex_color[2][4];  /* Mike  11-01-2005 */

	/* --- set up defaults --- */
	scale = 17.0;				/* 17 cm wide boxes				*/
	window = 20.0;				/* basic size					*/
	magnify = 1.0;				/* no magnification				*/
	gridon = 1;				/* show the grid				*/
	coloron = 1;				/* color 						*/
	while ((c = getopt(argc, argv, "hm:s:g")) != EOF)
	switch (c)  {
	case 'h':  fprintf(stderr,"Usage: %s [options]\n",argv[0]);
fprintf(stderr,"Options:\n");
fprintf(stderr," -h   : this help message\n");
fprintf(stderr," -s # : size of box(es) in cm [%.1f]\n",scale);
fprintf(stderr," -m # : magnification factor \n");
fprintf(stderr," -g   : turn grid off\n");
				exit(1);
				break;
		case 'm': magnify = atof(optarg);
				break;
		case 's': scale = atof(optarg);
				break;
		case 'g': gridon = 0;
				break;
        }


	xcen = 0.0; ycen = 0.0;		/* center on 0,0				*/
	window = window/magnify;
	printheader();
	offsetx = 1.5;					/* lower left corner of picture */
	offsety = 1.5;
	/* --- done with initialization stuff --- */
	thecolors[0][1] = 1.0;  thecolors[1][1] = 1.0;  thecolors[2][1] = 1.0;
	thecolors[0][2] = 0.5;  thecolors[1][2] = 0.5;  thecolors[2][2] = 0.5;
	thecolors[0][3] = 0.0;  thecolors[1][3] = 0.0;  thecolors[2][3] = 0.0;
	thecolors[0][4] = 1.0;  thecolors[1][4] = 0.0;  thecolors[2][4] = 0.0;
	thecolors[0][5] = 0.0;  thecolors[1][5] = 1.0;  thecolors[2][5] = 0.0;
	thecolors[0][6] = 0.0;  thecolors[1][6] = 0.0;  thecolors[2][6] = 1.0;
	thecolors[0][7] = 0.0;  thecolors[1][7] = 1.0;  thecolors[2][7] = 1.0;
	thecolors[0][8] = 1.0;  thecolors[1][8] = 1.0;  thecolors[2][8] = 0.0;
	thecolors[0][9] = 1.0;  thecolors[1][9] = 0.0;  thecolors[2][9] = 1.0;
	target[0] = 1;
	target[1] = 2;
	target[2] = 3;
	target[3] = 4;
	target[4] = 5;
	target[5] = 6;
	target[6] = 7;
	target[7] = 8;
	target[8] = 9;
	target[9] = 1;
	target[10] = 3;
	target[11] = 5;
	target[12] = 7;
	target[13] = 9;
	target[14] = 2;
	target[15] = 4;
	target[16] = 6;
	target[17] = 8;
	target[18] = 1;
	target[19] = 4;
	target[20] = 7;
	target[21] = 1;
	target[22] = 5;
	target[23] = 8;
	target[24] = 2;
	target[25] = 5;
	target[26] = 9;
	target[27] = 3;
	target[28] = 6;
	target[29] = 9;
	target[30] = 4;
	target[31] = 8;
	target[32] = 3;
	target[33] = 7;
	target[34] = 2;
	target[35] = 6;
	target[36] = 1;

	setcolor = 1;
	printf("/Palatino-Roman findfont\n");
	printf("0.25 scalefont\n");
	printf("setfont\n");
	x = 1.0; y = 2.0;
	size = 0.7;
	ttt = -1; rrr = 0;
	for (aa = 0.0;aa<1.0;aa+=.199)  {
		for (bb=0.0;bb<1.0;bb+=.199)  {
			for (cc=0.0;cc<1.0;cc+=.199)  {
				color[0][0] = 0.0;
				getcolor();
                                hex_color[0][1] = color[0][1] * 255;
                                hex_color[0][2] = color[0][2] * 255;
                                hex_color[0][3] = color[0][3] * 255;
				plot(x,y,0);
				plot(x+size,y,1);
				plot(x+size,y+size,1);
				plot(x,y+size,2);
				/*
					printf("%.2f %.2f m",x,y-0.5);
					printf("(%.2f %.2f %.2f) show\n",aa,bb,cc);
				*/
/*  Mike 11-01-2004		printf("%.2f %.2f m",x+0.2,y-0.35); */
				printf("%.2f %.2f m",x,y-0.35);
		 		printf("(%02x %.2f) show\n",hex_color[0][1], color[0][1]);
/*				printf("(%.2f) show\n",color[0][1]); */
				printf("%.2f %.2f m",x,y-0.60);
				printf("(%02x %.2f) show\n",hex_color[0][2], color[0][2]);
/*				printf("(%.2f) show\n",color[0][2]); */
				printf("%.2f %.2f m",x,y-.85);
				printf("(%02x %.2f) show\n",hex_color[0][3], color[0][3]);
/*				printf("(%.2f) show\n",color[0][3]); */
				x += size+0.3;
				if (x>24)  {
					x = 1.0;
					y+=2.2;
				}
			}
		}
	}



	printtrailer();
	exit(0);
} /* END OF MAIN /* END OF MAIN /* END OF MAIN /* END OF MAIN /* END OF MAIN */



















/*  PPPP   L       OOO   TTTTT
 *  P   P  L      O   O    T
 *  PPPP   L      O   O    T
 *  P      L      O   O    T
 *  P      LLLLL   OOO     T
 */

int plot(double x,double y,int plotflag)  {
	double dx,dy,swap;
	double cmx,cmy;		/* x,y in centimeters */
	int value,cell;
	/* flag variable:  0 = start line; 1 = lineto; 2 = endpoint */

	value = 0;
	cell = 0;

		cmx = x; cmy = y;
		if (plotflag==0)  {
			printf("%.2f %.2f m\n",cmx,cmy);
		} else {
			if (oldflag==1)  printf("%.2f %.2f m\n",cmx,cmy);
			printf("%.2f %.2f l\n",cmx,cmy);
			if (plotflag==2)  {
				printf("cp\n");			/* closepath */
				if (gridon == 1)  {
					printf("g\n");			/* gsave */
					if (setcolor==1)  printcolor(coloron,cell);
					printf("i h a\n");		/* fill grestore stroke */
				} else {
					if (setcolor==1)  printcolor(coloron,cell);
					printf("i\n");			/* fill */
				}
			}
		}
		oldflag = 0;

	return value;
}







/* =============== */
void printcolor(int coloron, int i)
{
	if (coloron==1)  {
		printf("%.2f %.2f %.2f sr\n",color[i][1],color[i][2],color[i][3]);
	} else {
		printf("%.2f sg\n",color[i][0]);
	}
}









/* Subroutine for plot */
double getdx(double x,double center)
{
	double dx;

	dx = (x - center) / window;
	dx = 0.5 * (dx + 1.0);
	/*  dx  : 0 = left/bottom, +1 = right/top */
	return dx;
}





/* ===================== */





























/* VARIOUS POSTSCRIPT STUFF */




void printheader()  {
/* ================================================================ */
/*  PostScript Header (taken from CGLE output)
 * ================================================================ */

printf("%%!PS-Adobe-1.0 \n\
%%%%HiResBoundingBox: -1 -1 766.354 567.929 \n%%%%EndComments \n%%%%EndProlog \n\
gsave \n\
 \n\
/f {findfont exch scalefont setfont} bind def \n\
/s {show} bind def \n\
/ps {true charpath} bind def \n\
/l {lineto} bind def \n\
/m {newpath moveto} bind def \n\
/sg {setgray} bind def\n\
/sr {setrgbcolor} bind def\n\
/a {stroke} bind def\n\
/cp {closepath} bind def\n\
/g {gsave} bind def\n\
/h {grestore} bind def\n\
/i {fill} bind def\n\
matrix currentmatrix /originmat exch def \n\
/umatrix {originmat matrix concatmatrix setmatrix} def \n\
 \n\
  [28.3465 0 0 28.3465 42.5197 28.6299] umatrix \n\
 %% Flipping coord system \n\
0 0 m \n\
  [8.35928e-09 28.3465 -28.3465 8.35928e-09 609.449 28.6299] umatrix \n\
 0 0 m \n\
%f setlinewidth \n\
0 0 0 setrgbcolor \n\
0 0 m \n\
%f setlinewidth \n",BOXLINE,BOXLINE);
/* END OF HEADER =============================================== */

}











void printtrailer()  {

printf("showpage \n\
grestore \n\
%%%%Trailer\n");

}





