/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class queuefile {
    public static final String nl = (String)System.getProperties().get("line.separator");
    private String name;
    private boolean removeurls;
    private boolean keepempty;
    private long lastmod;
    private boolean changed;
    private Vector lines;

    public queuefile(String fn) {
        this(fn, dmachine.removefromqueues, dmachine.keepemptyqueues);
    }

    public queuefile(String fn, boolean rem, boolean keep) {
        if (fn == null) {
            throw new IllegalArgumentException("Queue file can not be null");
        }
        this.name = fn;
        this.removeurls = rem;
        this.keepempty = keep;
        this.lastmod = 0L;
        this.changed = false;
        this.lines = new Vector();
    }

    public boolean isModified() {
        File qf = new File(this.name);
        if (this.lastmod == 0L) {
            return qf.isFile() && qf.canRead();
        }
        if (!qf.isFile() || !qf.canRead()) {
            return true;
        }
        return qf.lastModified() != this.lastmod;
    }

    public void loadfile() {
        this.loadfile(this.name);
    }

    public void loadfile(String fname) {
        this.lines = new Vector(this.lines.size() + 1);
        boolean loaded = this.appendFile(fname);
        this.changed = false;
        if (!loaded && !this.keepempty) {
            new File(fname).delete();
        }
        this.lastmod = new File(fname).lastModified();
    }

    public boolean appendFile(String fname) {
        boolean empty = true;
        try {
            String line;
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fname)));
            while ((line = dis.readLine()) != null) {
                if (line.trim().length() > 0) {
                    empty = false;
                    this.changed = true;
                }
                this.lines.addElement(line);
            }
            dis.close();
        }
        catch (IOException ioe) {
            empty = true;
        }
        return !empty;
    }

    public void savefile() {
        if (!this.changed) {
            return;
        }
        if (this.lines.size() == 0 && !this.keepempty) {
            new File(this.name).delete();
            this.lastmod = 0L;
            this.changed = false;
            return;
        }
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.name), 4096));
            for (int i = 0; i < this.lines.size(); ++i) {
                String line = (String)this.lines.elementAt(i);
                dos.writeBytes(line);
                dos.writeBytes(nl);
            }
            dos.close();
            this.lastmod = new File(this.name).lastModified();
            this.changed = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removeURL(String url) {
        if (url == null) {
            return;
        }
        if (!this.removeurls) {
            return;
        }
        int i = this.lines.size() - 1;
        if (!dmachine.case_sensitive) {
            url = url.toLowerCase();
        }
        while (i >= 0) {
            String line = (String)this.lines.elementAt(i);
            StringTokenizer st = new StringTokenizer(line, "\r\n\t #");
            if (st.hasMoreTokens()) {
                line = st.nextToken();
                if (!dmachine.case_sensitive) {
                    line = line.toLowerCase();
                }
                if (line.equals(url)) {
                    this.lines.removeElementAt(i);
                    this.changed = true;
                }
            }
            --i;
        }
    }

    public Vector getLines() {
        return (Vector)this.lines.clone();
    }

    public boolean exists() {
        return this.lastmod > 0L;
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.lines.setSize(0);
        this.changed = true;
    }
}

