/*
 * Decompiled with CFR 0.152.
 */
package net.fsp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.fsp.FSPInputStream;
import net.fsp.FSPOutputStream;
import net.fsp.FSPsession;
import net.fsp.FSPstat;
import net.fsp.FSPutil;

public class FSPURLConnection
extends URLConnection {
    private FSPsession ses;
    private FSPstat stat;
    private static String[] header_fields = new String[]{"last-modified", "content-length"};

    protected FSPURLConnection(URL u) {
        super(u);
        this.allowUserInteraction = false;
        this.useCaches = false;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.doInput && this.doOutput) {
            throw new UnsupportedOperationException("FSP supports reading OR writing files");
        }
        if (!this.doInput && !this.doOutput) {
            throw new IllegalStateException("You must call setDoInput() or setDoOutput() before calling connect()");
        }
        this.ses = new FSPsession(this.url.getHost(), this.url.getPort());
        this.ses.setTimeout(this.getConnectTimeout());
        this.stat = FSPutil.stat(this.ses, this.url.getFile());
        this.connected = true;
        this.ses.setTimeout(this.getReadTimeout());
    }

    public int getConnectTimeout() {
        return this.ses.getTimeout();
    }

    public String getContentEncoding() {
        return null;
    }

    public int getContentLength() {
        if (this.doOutput || !this.connected || this.stat == null) {
            return -1;
        }
        return (int)this.stat.length;
    }

    public String getContentType() {
        return null;
    }

    public long getDate() {
        return 0L;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return false;
    }

    public boolean getDefaultUseCaches() {
        return false;
    }

    public long getExpiration() {
        return 0L;
    }

    public String getHeaderField(int n) {
        if (n >= header_fields.length) {
            return null;
        }
        if (n < 0) {
            throw new IllegalArgumentException("header field number must be positive");
        }
        return this.getHeaderField(header_fields[n]);
    }

    public String getHeaderField(String name) {
        if (this.stat == null) {
            return null;
        }
        if (name.equals("last-modified")) {
            return new Date(this.stat.lastmod).toString();
        }
        if (name.equals("content-length")) {
            return Long.toString(this.stat.length);
        }
        return null;
    }

    public long getHeaderFieldDate(String name, long Default) {
        if (this.stat == null || !name.equals("last-modified")) {
            return Default;
        }
        return this.stat.lastmod;
    }

    public int getHeaderFieldInt(String name, int Default) {
        if (this.stat == null || !name.equals("content-length")) {
            return Default;
        }
        return (int)this.stat.length;
    }

    public String getHeaderFieldKey(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("field number must be >=0");
        }
        if (n >= header_fields.length) {
            return null;
        }
        return header_fields[n];
    }

    public Map getHeaderFields() {
        if (this.stat == null) {
            return null;
        }
        HashMap rc = new HashMap(2, 1.0f);
        ArrayList<String> l = new ArrayList<String>();
        l.add(Long.toString(this.stat.length));
        rc.put("content-length", l);
        l = new ArrayList();
        l.add(new Date(this.stat.lastmod).toString());
        rc.put("last-modified", l);
        return rc;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        if (!this.doInput) {
            throw new IllegalStateException("URL not opened for reading");
        }
        if (this.stat == null) {
            throw new FileNotFoundException("File not found");
        }
        if (this.stat.type == 2) {
            throw new UnsupportedOperationException("Is a directory");
        }
        return new FSPInputStream(this.ses, this.url.getFile());
    }

    public long getLastModified() {
        if (this.stat != null) {
            return this.stat.lastmod;
        }
        return 0L;
    }

    public OutputStream getOutputStream() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        if (!this.doOutput) {
            throw new IllegalStateException("URL not opened for writing");
        }
        return new FSPOutputStream(this.ses, this.url.getFile());
    }

    public Permission getPermission() {
        return new SocketPermission(this.url.getHost() + ":" + this.ses.getPort(), "connect,resolve");
    }

    public boolean getUseCaches() {
        return false;
    }
}

