/*
 * Decompiled with CFR 0.152.
 */
package net.fsp;

import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import net.fsp.FSPURLConnection;

public class Handler
extends URLStreamHandler
implements URLStreamHandlerFactory {
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol == null) {
            return null;
        }
        if (protocol.equals("fsp")) {
            return new Handler();
        }
        return null;
    }

    protected boolean equals(URL u1, URL u2) {
        if (u1.getHost().equals(u2.getHost())) {
            int p1 = u1.getPort();
            int p2 = u2.getPort();
            p1 = p1 == -1 ? 21 : p1;
            int n = p2 = p2 == -1 ? 21 : p2;
            if (p1 == p2 && u1.getPath().equals(u2.getPath())) {
                return true;
            }
        }
        return false;
    }

    protected int getDefaultPort() {
        return 21;
    }

    protected int hashCode(URL u) {
        return this.toExternalForm(u).hashCode();
    }

    protected URLConnection openConnection(URL u) {
        return new FSPURLConnection(u);
    }

    protected String toExternalForm(URL u) {
        int p = u.getPort();
        if (p == 21) {
            p = -1;
        }
        return "fsp://" + u.getHost() + (p != -1 ? ":" + p : "") + u.getPath();
    }
}

