/*
 * Decompiled with CFR 0.152.
 */
package net.fsp;

import net.fsp.FSPpacket;

public class FSPversion
implements Cloneable {
    public String version;
    public boolean extended_info;
    public boolean logging;
    public boolean read_only;
    public boolean reverse;
    public boolean private_mode;
    public long throughput;
    public boolean extra_data;
    public short payload;

    public FSPversion() {
    }

    public FSPversion(FSPpacket pkt) {
        if (pkt.cmd != 16) {
            throw new IllegalArgumentException("Packet is not response to CC_VERSION");
        }
        this.version = new String(pkt.buf, 0, (int)pkt.bb_len).trim();
        if (pkt.bb_pos > 0 && pkt.xtra_len > 0) {
            this.extended_info = true;
            byte flags = pkt.buf[pkt.bb_len];
            this.logging = (flags & 1) != 0;
            this.read_only = (flags & 2) != 0;
            this.reverse = (flags & 4) != 0;
            this.private_mode = (flags & 8) != 0;
            if ((flags & 0x10) != 0 && pkt.xtra_len > 4) {
                this.throughput = (pkt.buf[pkt.bb_len + 1] << 8 | pkt.buf[pkt.bb_len + 2] & 0xFF) << 16;
                this.throughput |= (long)((pkt.buf[pkt.bb_len + 3] & 0xFF) << 8 | pkt.buf[pkt.bb_len + 4] & 0xFF);
            } else {
                flags = (byte)(flags & 0xEF);
                this.throughput = 0L;
            }
            this.extra_data = (flags & 0x20) != 0;
            pkt.bb_len = (flags & 0x10) != 0 && pkt.xtra_len >= 7 ? (short)(pkt.bb_len + 5) : ((flags & 0x10) == 0 && pkt.xtra_len >= 3 ? (short)(pkt.bb_len + 1) : (short)0);
            this.payload = pkt.bb_len > 0 ? (short)(pkt.buf[pkt.bb_len] << 8 | pkt.buf[pkt.bb_len + 1] & 0xFF) : (short)0;
        } else {
            this.extended_info = false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FSPversion newver = new FSPversion();
        newver.version = this.version;
        newver.logging = this.logging;
        newver.read_only = this.read_only;
        newver.reverse = this.reverse;
        newver.private_mode = this.private_mode;
        newver.throughput = this.throughput;
        newver.extra_data = this.extra_data;
        newver.payload = this.payload;
        newver.extended_info = this.extended_info;
        return newver;
    }
}

