/*
 * Decompiled with CFR 0.152.
 */
package net.fsp;

import net.fsp.FSPpacket;

public class FSPprotection {
    public boolean owner;
    public boolean delete;
    public boolean add;
    public boolean mkdir;
    public boolean get;
    public boolean list;
    public boolean rename;
    public String readme;
    public static byte DIR_OWNER = 1;
    public static byte DIR_DEL = (byte)2;
    public static byte DIR_ADD = (byte)4;
    public static byte DIR_MKDIR = (byte)8;
    public static byte DIR_GET = (byte)16;
    public static byte DIR_README = (byte)32;
    public static byte DIR_LIST = (byte)64;
    public static byte DIR_RENAME = (byte)-128;

    public FSPprotection() {
    }

    public FSPprotection(FSPpacket pkt) {
        if (pkt.cmd != 71) {
            throw new IllegalArgumentException("Packet is not response to CC_GET_PRO");
        }
        if (pkt.bb_len > 0) {
            this.readme = new String(pkt.buf, 0, pkt.bb_len - 1);
        }
        if (pkt.bb_pos > 0 && pkt.xtra_len > 0) {
            byte prot = pkt.buf[pkt.bb_len];
            if ((prot & DIR_OWNER) != 0) {
                this.owner = true;
            }
            if ((prot & DIR_DEL) != 0) {
                this.delete = true;
            }
            if ((prot & DIR_ADD) != 0) {
                this.add = true;
            }
            if ((prot & DIR_MKDIR) != 0) {
                this.mkdir = true;
            }
            if ((prot & DIR_GET) == 0) {
                this.get = true;
            }
            if ((prot & DIR_LIST) != 0) {
                this.list = true;
            }
            if ((prot & DIR_RENAME) != 0) {
                this.rename = true;
            }
        } else {
            this.get = true;
            this.list = true;
        }
    }
}

