/* $Id: rtinfo.c,v 1.3 2007-11-12 07:59:50 kiesling Exp $ */

/*
  This file is part of ctalk.
  Copyright  2005-2007  Robert Kiesling, rkiesling@users.sourceforge.net.
  Permission is granted to copy this software provided that this copyright
  notice is included in all source code modules.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 51 Franklin St., Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "ctpp.h"
#include "prtinfo.h"

RT_INFO rtinfo;

static char argv_name[FILENAME_MAX];

char source_file[FILENAME_MAX];
char appname[FILENAME_MAX];

int nolinemarker_opt = FALSE;        /* Don't include line info in output. */
int nostdinc_opt = FALSE;            /* Don't include standard libraries.  */
int keep_pragma_opt = FALSE;         /* Keep pragmas in the output.        */
int warndollar_opt = FALSE;          /* Warn if $ is an identifier char.   */
int warnundefsymbols_opt = FALSE;    /* Warn if a symbol is undefined.     */
int keepcomments_opt = FALSE;        /* Pass comments thru to the output.  */
int warnnestedcomments_opt = FALSE;  /* Generate nested comment warnings.  */
int unassert_opt = FALSE;            /* -A- option.                        */
int definestooutput_opt = FALSE;     /* -dD option.                        */
int definesonly_opt = FALSE;         /* -dM option.                        */
int definestofile_opt = FALSE;       /* -dF option.                        */
int makerule_opts = 0;               /* -M options.                        */
int undef_builtin_macros_opt = FALSE;/* -u | -undef option.         */
int use_trigraphs_opt = FALSE;       /* -trigraphs option.                 */
int warn_trigraphs_opt = FALSE;      /* -Wtrigraphs option.                */
int warn_all_opt = FALSE;            /* -Wall option.                      */
int verbose_opt = FALSE;             /* -v option.                         */
int no_warnings_opt = FALSE;         /* -w option.                         */
int lang_cplusplus_opt = FALSE;      /* -lang-c++ option.                  */
int warnings_to_errors_opt = FALSE;  /* -Werror option.                    */
int print_headers_opt = FALSE;       /* -H option.                         */
int pre_preprocessed_opt = FALSE;    /* -fpreprocessed opt.                */
int gcc_macros_opt = TRUE;           /* -gcc option - enabled by default.  */
int definenamesonly_opt = FALSE;     /* -dN option.                        */
int warnunused_opt = FALSE;          /* -Wunused option.                   */
int no_include_opt = FALSE;          /* --no-include option.               */
int no_simple_macros_opt = FALSE;    /* --no-simple-macros option.         */
int move_includes_opt = FALSE;       /* --move-includes                    */

void __argvName (char *s) {
   strcpy (argv_name, s);
}

char *__argvFileName (void) {
  return argv_name;
}

void __source_file (char *s) {
  strcpy (rtinfo.source_file, s);
}

char *__source_filename (void) {
  return rtinfo.source_file;
}

void __init_time (void) {
   time_t t;
   struct tm *tm_ptr;
   t = time (NULL);
   tm_ptr = localtime (&t);
}
