/* $Id: rt_error.c,v 1.2 2007-11-12 07:59:50 kiesling Exp $ -*-c-*-*/

/*
  This file is part of ctalk.
  Copyright  2005-2007  Robert Kiesling, rkiesling@users.sourceforge.net.
  Permission is granted to copy this software provided that this copyright
  notice is included in all source code modules.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 51 Franklin St., Fifth Floor, Boston, MA 02110-1301 USA.
*/

/*
 *   Format and output error and warning messages.
 */

#ifndef MAXMSG             /* Defined in ctalk.h. */
#define MAXMSG 8192
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

extern int no_warnings_opt;         /* -w option.                  */
extern int warnings_to_errors_opt;  /* -Werror option.             */

extern char *_format_str (char *, char *, va_list);
extern void _error_out (char *);
extern void cleanup (int);

void _error (char *fmt, ...) {
  va_list ap;
  char buf[MAXMSG], fmtbuf[MAXMSG];
  va_start (ap, fmt);
  sprintf (buf, "%s", _format_str (fmtbuf, fmt, ap));
  _error_out (buf);
  cleanup (1);
  exit (1);
}

void _warning (char *fmt, ...) {
  va_list ap;
  char buf[MAXMSG], fmtbuf[MAXMSG];
  if (no_warnings_opt) return;
  if (warnings_to_errors_opt) _error (fmt);
  va_start (ap, fmt);
  sprintf (buf, "%s", _format_str (fmtbuf, fmt, ap));
  _error_out (buf);
}

