/* $Id: pcvars.c,v 1.2 2007-11-12 08:08:15 kiesling Exp $ */

/*
  This file is part of ctalk.
  Copyright  2005-2007 Robert Kiesling, rkiesling@users.sourceforge.net.
  Permission is granted to copy this software provided that this copyright
  notice is included in all source code modules.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation, 
  Inc., 51 Franklin St., Fifth Floor, Boston, MA 02110-1301 USA.
*/

/*
 *  Abbreviated version of cvars.c in the main ctalk code.  Only
 *  pmatch_type is used for pmatch_type () is used.
 *  etc.
 */

#include <stdio.h>
#include <stddef.h>
#include <errno.h>
#include "ctpp.h"
#include "typeof.h"

int pmatch_type (VAL *val1, VAL *val2) {

  int retval = ERROR;

  if (val1 -> type == val2 -> type) {
    retval = SUCCESS;
  } else {

    switch (val1 -> type) 
      {
      case INTEGER_T:
	switch (val2 -> type)
	  {
	  case LONG_T:
	    val1 -> type = LONG_T;
	    retval = SUCCESS;
	    break;
	  case LONGLONG_T:
	    val1 -> type = LONGLONG_T;
	    val1 -> value.ll = (long long) val1 -> value.i;
	    retval = SUCCESS;
	    break;
	  }
	break;
      case LONG_T:
	switch (val2 -> type)
	  {
	  case INTEGER_T:
	    val2 -> type = LONG_T;
	    retval = SUCCESS;
	    break;
	  case LONGLONG_T:
	    val1 -> type = LONGLONG_T;
	    val1 -> value.ll = (long long) val1 -> value.l;
	    retval = SUCCESS;
	    break;
	  }
	break;
      case LONGLONG_T:
	switch (val2 -> type)
	  {
	  case INTEGER_T:
	    val2 -> type = LONGLONG_T;
	    val2 -> value.ll = (long long) val2 -> value.i;
	    retval = SUCCESS;
	    break;
	  case LONG_T:
	    val2 -> type = LONGLONG_T;
	    val2 -> value.ll = (long long) val2 -> value.l;
	    retval = SUCCESS;
	    break;
	  }
	break;
      default:
	_warning ("Unimplemented type %d in match_type.", val1 -> type);
	break;
      }
  }
  

  return retval;
}

