/*
   sndcaplib.h -- Private header for the sound capture library

   Copyright (C) 2007 Laszlo Menczel
   
   This is free software with NO WARRANTY. Distributed under
   the GNU Library General Public Licence (LGPL) version 2.1.
*/

#if ! defined _SNDCAPLIB_H
#define _SNDCAPLIB_H

extern ringbuf_t *__scap_buf;
extern int __scap_init;
extern int __scap_recording;
extern int __scap_num_buf;
extern int __scap_num_chan;
extern int __scap_dat_size;
extern int __scap_err;
extern int __scap_cap_freq;

#define ERR(x)		{ __scap_err = (x); return 0; }
#define ERR_P(x)	{ __scap_err = (x); return NULL; }
#define RETURN(x)	{ __scap_err = 0; return (x); }

int  __scap_open_device(void);
void __scap_close_device(void);
int  __scap_start(void);
int  __scap_stop(void);

#endif  /* _SNDCAPLIB_H */
