/*

  resample.h

  Real-time library interface by Dominic Mazzoni

  Based on resample-1.7:
    http://www-ccrma.stanford.edu/~jos/resample/

  License: LGPL - see the file LICENSE.txt for more information

  ==============================================================
  
  Modified by Laszlo Menczel (August 2007) for inclusion in the
  SNDCAP library. Merged all header files (libresample.h, filterkit.h
  and resample_defs.h) into this file. Added the prefix 'scap_' to
  the public functions.
*/

#if ! defined _RESAMPLE_H
#define _RESAMPLE_H

#if defined __cplusplus
extern "C" {
#endif

//======================================================================

#if ! defined TRUE
#define TRUE  1
#endif

#if ! defined FALSE
#define FALSE 0
#endif

#if ! defined PI
#define PI (3.14159265358979232846)
#endif

#if ! defined PI2
#define PI2 (6.28318530717958465692)
#endif

#define D2R (0.01745329348)     /* (2*pi)/360 */
#define R2D (57.29577951)       /* 360/(2*pi) */

#if ! defined MAX
#define MAX(x,y) ((x)>(y) ?(x):(y))
#endif

#if ! defined MIN
#define MIN(x,y) ((x)<(y) ?(x):(y))
#endif

#if ! defined ABS
#define ABS(x)   ((x)<0   ?(-(x)):(x))
#endif

#if ! defined SGN
#define SGN(x)   ((x)<0   ?(-1):((x)==0?(0):(1)))
#endif

//======================================================================

void *scap_resample_open(int highQuality, double minFactor, double maxFactor);

void *scap_resample_dup(const void *handle);

int scap_resample_get_filter_width(const void *handle);

int scap_resample_process
(
  void *handle, double factor, float *inBuffer, int inBufferLen, intlastFlag,
  int *inBufferUsed, float *outBuffer, int outBufferLen
);

void scap_resample_close(void *handle);

#if defined __cplusplus
}
#endif

#endif /* _RESAMPLE_H */
