/*
   capture_win32.c  --  Windows specific functions
   
   SCAP Voice Capture Library
   
   Copyright (C) 2007 Laszlo Menczel
   
   This is free software with NO WARRANTY. Distributed under
   the GNU Library General Public Licence (LGPL) version 2.1.
*/

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <mmsystem.h>

#include "sndcap.h"
#include "sndcaplib.h"

static HWAVEIN dev = INVALID_HANDLE_VALUE;
static WAVEHDR whdr;

//============================================================================

static int queue_next_buf(void)
{
  MMRESULT res;

  whdr.lpData = (char *) (__scap_buf->data + __scap_buf->head);
  whdr.dwBufferLength = (dword) __scap_buf->incr;
  res = waveInPrepareHeader(dev, &whdr, sizeof(WAVEHDR));
  
  if (res != MMSYSERR_NOERROR)
    return 0;
  
  res = waveInAddBuffer(dev, &whdr, sizeof(WAVEHDR));

  if (res != MMSYSERR_NOERROR)
    return 0;
  
  return 1;
}  

//============================================================================

static void CALLBACK cb_func(HWAVEIN h, UINT msg, DWORD udat, DWORD p1, DWORD p2)
{
  switch (msg)
  {
    case WIM_DATA:
      rbuf_incr(__scap_buf, RBUF_HEAD);	// select next chunk in ring buffer
      waveInUnprepareHeader(dev, &whdr, sizeof(WAVEHDR));
      queue_next_buf();
      break;

    default:
      break;
  }
}

//============================================================================
// Internally used global functions
//============================================================================

int __scap_open_device(void)
{
  WAVEFORMATEX wfx;
  MMRESULT res;
  
  wfx.wFormatTag = WAVE_FORMAT_PCM;
  wfx.nChannels = (WORD) __scap_num_chan;
  wfx.nSamplesPerSec = (DWORD) __scap_cap_freq;
  wfx.wBitsPerSample = (WORD) __scap_dat_size;
  wfx.nBlockAlign = (WORD) ((wfx.nChannels * wfx.wBitsPerSample) / 8);
  wfx.nAvgBytesPerSec = (wfx.nSamplesPerSec * wfx.nBlockAlign);
  wfx.cbSize = 0;

  res = waveInOpen(&dev, WAVE_MAPPER, &wfx, (dword) cb_func, 0, CALLBACK_FUNCTION);

  if (res != MMSYSERR_NOERROR)
    return 0;

  return 1;
}

//============================================================================

int __scap_start(void)
{
  MMRESULT res;

  res = waveInStart(dev);

  if (res != MMSYSERR_NOERROR)
    ERR(CAPERR_START)
    
  if (! queue_next_buf())
  {
    waveInReset(dev);
    waveInUnprepareHeader(dev, &whdr, sizeof(WAVEHDR));
    waveInClose(dev);
    ERR(CAPERR_BUF_ADD)
  }
  
  RETURN(1)
}

//============================================================================

int __scap_stop(void)
{
  MMRESULT res;

  res = waveInStop(dev);
  if (res != MMSYSERR_NOERROR)
    return 0;
    
  res = waveInUnprepareHeader(dev, &whdr, sizeof(WAVEHDR));
  if (res != MMSYSERR_NOERROR)
    return 0;

  RETURN(1)
}

//============================================================================

void __scap_close_device(void)
{
  if (dev != INVALID_HANDLE_VALUE)
    waveInClose(dev);
}
