/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2009 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef PINENTRY_H
#define PINENTRY_H

#include "types.h"

void _pinentry_disconnect(pwm_t *pwm)
    __attribute__ ((visibility ("hidden")));

gpg_error_t _getpin(pwm_t *pwm, char **result, pwmd_pinentry_t which)
    __attribute__ ((visibility ("hidden")));

gpg_error_t _do_save_getpin(pwm_t *pwm, char **password)
    __attribute__ ((visibility ("hidden")));

gpg_error_t _pinentry_open(pwm_t *pwm, const char *filename, char **password,
	int nb)
    __attribute__ ((visibility ("hidden")));

gpg_error_t _pwmd_getpin(pwm_t *pwm, const char *filename, char **result,
	pwmd_pinentry_t which)
    __attribute__ ((visibility ("hidden")));

#endif
