/*
                               ARRAY.C

                         Array manipulation
                    
                   Copyright (C) Laszlo Menczel, 2005
                         menczel@invitel.hu

        This is free software without warranty. See 'licence.txt'.
*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "mutil.h"
#include "mutlib.h"

//==========================================================================

int mut_iarray_sum(int *arr, int last_index)
{
  int i, sum;

  if (arr == NULL || last_index < 0)
    MUTERR(MUTERR_BAD_ARG)

  for (i = 0, sum = 0; i <= last_index; i++)
    sum += arr[i];

  RETURN(sum)
}

//==========================================================================

double mut_darray_sum(double *arr, int last_index)
{
  int i;
  double sum;

  if (arr == NULL || last_index < 0)
    MUTERR(MUTERR_BAD_ARG)

  for (i = 0, sum = 0.0; i <= last_index; i++)
    sum += arr[i];

  RETURN(sum)
}

//==========================================================================

char **mut_alloc_str_array(int count, int size)
{
  int n;
  char **new;

  if (count < 2 || size < 1)
    MUTERR_P(MUTERR_BAD_ARG)

  new = (char **) malloc(count * sizeof(char *));
  if (new == NULL)
    MUTERR_P(MUTERR_ALLOC)

  for (n = 0; n < count; n++)
    new[n] = NULL;

  for (n = 0; n < count; n++)
  {
    new[n] = (char *) malloc(size);
    if (new[n] == NULL)
      break;
    memset((void *) new[n], 0, size);
  }

  if (n < count)
  {
    for (n--; n >= 0; n--)
      free(new[n]);
    free(new);
    MUTERR_P(MUTERR_ALLOC)
  }

  RETURN(new)
}

//==========================================================================

int mut_free_str_array(char **array, int count)
{
  int n;

  if (array == NULL || count < 2)
    MUTERR(MUTERR_BAD_ARG)

  for (n = 0; n < count; n++)
    if (array[n] != NULL)
      free(array[n]);

  free(array);

  RETURN(1)
}

//==========================================================================

int mut_create_str_ptrs(char **array, int count, int size)
{
  int n;

  if (array == NULL || count < 2 || size < 1)
    MUTERR(MUTERR_BAD_ARG)
  
  for (n = 0; n < count; n++)
    array[n] = NULL;

  for (n = 0; n < count; n++)
  {
    array[n] = (char *) malloc(size);
    if (array[n] == NULL)
      break;
    memset((void *) array[n], 0, size);
  }

  if (n < count)
  {
    for (n--; n >= 0; n--)
      free(array[n]);
    MUTERR(MUTERR_ALLOC)
  }

  RETURN(1)
}

//==========================================================================

int mut_delete_str_ptrs(char **array, int count)
{
  int n;
  
  if (array == NULL || count < 2)
    MUTERR(MUTERR_BAD_ARG)

  for (n = 0; n < count; n++)
    if (array[n] != NULL)
      free(array[n]);

  RETURN(1)
}
