#include <stdio.h>
#include <stdlib.h>

#include <limits.h>
#include <float.h>
#include <string.h>


#define VERSION "0.1"


int decode_7_in_8(int length)
{
int a, i, j;
char hex[80];
unsigned int code;
int count;
char temp[20];
int bits[2048];
int bit;
unsigned char p;

count = 0;
bit = 0;
while(1)
	{
	for(i = 0; i < 7; i++)
		{
		a = fscanf(stdin, "%2s", hex);	
		if(a == EOF) break;

		sprintf(temp, "0x%s", hex);
		sscanf(temp, "%x", &code);

//fprintf(stderr, "temp=%s\n", temp);
		p = code;		

//fprintf(stderr, "p=%d\n", p);
		/* strip of high bit and move to lsb of next */	
		/* lsb first */

		for(j = 0; j < 8; j++)
			{
			bits[bit] = (code >> (j) ) & 0x1;

//fprintf(stderr, "bits[%d]=%d\n", bit, bits[7 - bit]);

			bit++;

			}

		count++;
		if(count >= length) break;
		}

	if(a == EOF) break;
	if(count >= length) break;

	} /* end while read input */

//fprintf(stderr, "bit=%d\n", bit);

/*
for(i = 0; i < bit; i++)
	{
	fprintf(stderr, "%d", bits[i]);
	}

fprintf(stdout, "\n");
*/

a = bit;
bit = 0;
//for(i = 0; i < length + 1; i++) /* HACK length + 1 ??? */
for(i = 0; i < a / 7; i++)
	{
	code = 0;
	for(j = 0; j < 7; j++)
		{
		code |= bits[bit + 6 - j] << (6 - j);

//		fprintf(stderr, "i=%d j=%d bit=%d c=%d b=%d\n", i, j, bit, c, b);
		}
	bit += 7;
	
//	fprintf(stderr, "%d ", code);
	fprintf(stdout, "%c", code);
	}

return 1;
} /* end function decode_7_in_8 */


int main(int argc, char **argv)
{
int a, i;
char hex[80];
char temp[20];
char hex1[2];
char hex2[2];


fprintf(stderr, "Panteltje (c) parse_sms-%s\n", VERSION); 

fprintf(stderr,\
"\
Usage: if XXXX is the PDU message\n\
echo \"XXXXXXXXXXXXXX\" | parse_sms\n\
or\n\
echo \"XXXXXXXXXXXXXX\" | parse_sms > sms_message.txt\n\
");

/* parse header */

//07									Length of the SMSC information				hex-octet									7 octets
int smsc_len;
a = fscanf(stdin, "%2s", hex);
if(a == EOF)
	{
	fprintf(stderr, "Early EOF\n");

	exit(1);
	}

sprintf(temp, "0x%s", hex);
sscanf(temp, "%x", &smsc_len);
fprintf(stdout, "smsc_len=%d\n", smsc_len);


//91									Type of address of SMSC						hex-octet									internation format
int smsc_address_type;
a = fscanf(stdin, "%2s", hex);
if(a == EOF)
	{
	fprintf(stderr, "Early EOF\n");

	exit(1);
	}

sprintf(temp, "0x%s", hex);
sscanf(temp, "%x", &smsc_address_type);
fprintf(stdout, "smsc_address_type=%d\n", smsc_address_type);


//13 26 04 00 00 F0					SMSC number									decimal semi-octets b						31624000000
fprintf(stdout, "SMSC Number: ");
for(i = 0; i < smsc_len - 1; i++)
	{
	a = fscanf(stdin, "%1s", hex1);
	if(a == EOF)
		{
		fprintf(stderr, "Early EOF\n");

		exit(1);
		}

	a = fscanf(stdin, "%1s", hex2);
	if(a == EOF)
		{
		fprintf(stderr, "Early EOF\n");

		exit(1);
		}

	if( (hex1[0] < '0') || (hex1[0] > '9') ) strcpy(hex1, " "); 
	if( (hex2[0] < '0') || (hex2[0] > '9') ) strcpy(hex2, " "); 

	/* swap nibbles */
	sprintf(temp, "%s%s", hex2, hex1);

	fprintf(stdout, "%s", temp);
	}
fprintf(stdout, "\n");



//04									First octet of this SMS-DELIVER message.	hex-octet									TP-MMS
int sms_deliver_1;
a = fscanf(stdin, "%2s", hex);
if(a == EOF)
	{
	fprintf(stderr, "Early EOF\n");

	exit(1);
	}

sprintf(temp, "0x%s", hex);
sscanf(temp, "%x", &sms_deliver_1);
fprintf(stdout, "sms_deliver_1=%d\n", sms_deliver_1);


//0B									Length of the sender address				hex-octet									11 (decimal)
int sender_address_length;
a = fscanf(stdin, "%2s", hex);
if(a == EOF)
	{
	fprintf(stderr, "Early EOF\n");

	exit(1);
	}

sprintf(temp, "0x%s", hex);
//fprintf(stderr, "hex=%s ", hex);
sscanf(temp, "%x", &sender_address_length);
fprintf(stdout, "sender_address_length=%d\n", sender_address_length);
/* if this is odd, add 1 */
if(sender_address_length % 2) sender_address_length += 1;



//91									Type of address of the sender number		hex-octet									...
int sender_address_type;
a = fscanf(stdin, "%2s", hex);
if(a == EOF)
	{
	fprintf(stderr, "Early EOF\n");

	exit(1);
	}

sprintf(temp, "0x%s", hex);
sscanf(temp, "%x", &sender_address_type);
fprintf(stdout, "sender_address_type=%d\n", sender_address_type);


//13 46 61 00 89 F6					Sender number								decimal semi-octets							31641600986
fprintf(stdout, "sender number: ");

/* !!!for address type alpha perhaps 7 in 8 bits ? */

if(sender_address_type == 208) // alpha follows
	{
	if(sender_address_length % 2) sender_address_length++;

	decode_7_in_8(sender_address_length / 2);
	}
else
	{
	for(i = 0; i < sender_address_length / 2; i++)
		{
		a = fscanf(stdin, "%1s", hex1);
		if(a == EOF)
			{
			fprintf(stderr, "Early EOF\n");

			exit(1);
			}

		a = fscanf(stdin, "%1s", hex2);
		if(a == EOF)
			{
			fprintf(stderr, "Early EOF\n");

			exit(1);
			}

		if( (hex1[0] < '0') || (hex1[0] > '9') ) strcpy(hex1, " "); 
		if( (hex2[0] < '0') || (hex2[0] > '9') ) strcpy(hex2, " "); 

		/* swap nibbles */
		sprintf(temp, "%s%s", hex2, hex1);

		fprintf(stdout, "%s", temp);
		}
	}
fprintf(stdout, "\n");


//00									Protocol identifier							hex-octets									...
int protocol_identifier;
a = fscanf(stdin, "%2s", hex);
if(a == EOF)
	{
	fprintf(stderr, "Early EOF\n");

	exit(1);
	}

sprintf(temp, "0x%s", hex);
sscanf(temp, "%x", &protocol_identifier);
fprintf(stdout, "protocol_identifier=%d\n", protocol_identifier);



//00									Data encoding scheme						hex-octets									...
int data_encoding_scheme;
a = fscanf(stdin, "%2s", hex);
if(a == EOF)
	{
	fprintf(stderr, "Early EOF\n");

	exit(1);
	}

sprintf(temp, "0x%s", hex);
sscanf(temp, "%x", &data_encoding_scheme);
fprintf(stdout, "data_encoding_scheme=%d\n", data_encoding_scheme);



//20 80 62 91 73 14 08				Time stamp c								decimal semi-octets							06-08-02 29:17:31
fprintf(stdout, "time stamp: ");
for(i = 0; i < 7; i++)
	{
	a = fscanf(stdin, "%1s", hex1);
	if(a == EOF)
		{
		fprintf(stderr, "Early EOF\n");

		exit(1);
		}

	a = fscanf(stdin, "%1s", hex2);
	if(a == EOF)
		{
		fprintf(stderr, "Early EOF\n");

		exit(1);
		}

	if( (hex1[0] < '0') || (hex1[0] > '9') ) strcpy(hex1, " "); 
	if( (hex2[0] < '0') || (hex2[0] > '9') ) strcpy(hex2, " "); 

	/* swap nibbles */
	sprintf(temp, "%s%s", hex2, hex1);

	fprintf(stdout, "%s", temp);
	if(i < 2) fprintf(stdout, "/");
	else if (i == 2) fprintf(stdout, " ");
	else if(i < 5) fprintf(stdout, ":");
	else if(i == 5) fprintf(stdout, " Timezone=");
	}
fprintf(stdout, "\n");



//0C									Length of User data (SMS message)			hex-octets									12 (decimal)
int user_data_length;
a = fscanf(stdin, "%2s", hex);
if(a == EOF)
	{
	fprintf(stderr, "Early EOF\n");

	exit(1);
	}

sprintf(temp, "0x%s", hex);
sscanf(temp, "%x", &user_data_length);
fprintf(stdout, "user_data_length=%d\n", user_data_length);



//C8 F7 1D 14 96 97 41 F9 77 FD 07	User data									8-bit octets respresenting 7-bit data		How are you?
//int decode_7_in_8(int length) 
decode_7_in_8(user_data_length);

fprintf(stdout, "\n");

exit(0);
} /* end function main */


